/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_Domain;
import org.jclouds.openstack.poppy.v1.domain.Protocol;

public abstract class Domain {
    public abstract String getDomain();

    @Nullable
    public abstract Protocol getProtocol();

    @SerializedNames(value={"domain", "protocol"})
    private static Domain create(String domain, Protocol protocol) {
        return Domain.builder().domain(domain).protocol(protocol).build();
    }

    public static Builder builder() {
        return new Builder().protocol(null);
    }

    public Builder toBuilder() {
        return Domain.builder().domain(this.getDomain()).protocol(this.getProtocol());
    }

    public static final class Builder {
        private String domain;
        private Protocol protocol;

        Builder() {
        }

        Builder(Domain source) {
            this.domain(source.getDomain());
            this.protocol(source.getProtocol());
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Domain build() {
            String missing = "";
            if (this.domain == null) {
                missing = missing + " domain";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_Domain result = new AutoValue_Domain(this.domain, this.protocol);
            return result;
        }
    }
}

