/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_Origin;
import org.jclouds.openstack.poppy.v1.domain.CachingRule;

public abstract class Origin {
    public abstract String getOrigin();

    @Nullable
    public abstract Integer getPort();

    @Nullable
    public abstract Boolean getSslEnabled();

    @Nullable
    public abstract List<CachingRule> getRules();

    @SerializedNames(value={"origin", "port", "ssl", "rules"})
    private static Origin create(String origin, int port, boolean sslEnabled, List<CachingRule> rules) {
        return Origin.builder().origin(origin).port(port).sslEnabled(sslEnabled).rules(rules).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Origin.builder().origin(this.getOrigin()).port(this.getPort()).sslEnabled(this.getSslEnabled()).rules(this.getRules());
    }

    public static final class Builder {
        private String origin;
        private Integer port;
        private Boolean sslEnabled;
        private List<CachingRule> rules;

        Builder() {
        }

        Builder(Origin source) {
            this.origin(source.getOrigin());
            this.port(source.getPort());
            this.sslEnabled(source.getSslEnabled());
            this.rules(source.getRules());
        }

        public Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder sslEnabled(Boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder rules(List<CachingRule> rules) {
            this.rules = rules;
            return this;
        }

        public Origin build() {
            String missing = "";
            if (this.origin == null) {
                missing = missing + " origin";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_Origin result = new AutoValue_Origin(this.origin, this.port, this.sslEnabled, (List<CachingRule>)(this.rules != null ? ImmutableList.copyOf(this.rules) : null));
            return result;
        }
    }
}

