/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_Restriction;
import org.jclouds.openstack.poppy.v1.domain.RestrictionRule;

public abstract class Restriction {
    public abstract String getName();

    @Nullable
    public abstract List<RestrictionRule> getRules();

    @SerializedNames(value={"name", "rules"})
    private static Restriction create(String name, List<RestrictionRule> rules) {
        return Restriction.builder().name(name).rules(rules).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Restriction.builder().name(this.getName()).rules(this.getRules());
    }

    public static final class Builder {
        private String name;
        private List<RestrictionRule> rules;

        Builder() {
        }

        Builder(Restriction source) {
            this.name(source.getName());
            this.rules(source.getRules());
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder rules(List<RestrictionRule> rules) {
            this.rules = rules;
            return this;
        }

        public Restriction build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_Restriction result = new AutoValue_Restriction(this.name, (List<RestrictionRule>)(this.rules != null ? ImmutableList.copyOf(this.rules) : null));
            return result;
        }
    }
}

