/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_RestrictionRule;

public abstract class RestrictionRule {
    public abstract String getName();

    public abstract String getHttpHost();

    @SerializedNames(value={"name", "referrer"})
    private static RestrictionRule create(String name, String httpHost) {
        return RestrictionRule.builder().name(name).httpHost(httpHost).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return RestrictionRule.builder().name(this.getName()).httpHost(this.getHttpHost());
    }

    public static final class Builder {
        private String name;
        private String httpHost;

        Builder() {
        }

        Builder(RestrictionRule source) {
            this.name(source.getName());
            this.httpHost(source.getHttpHost());
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder httpHost(String httpHost) {
            this.httpHost = httpHost;
            return this;
        }

        public RestrictionRule build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.httpHost == null) {
                missing = missing + " httpHost";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_RestrictionRule result = new AutoValue_RestrictionRule(this.name, this.httpHost);
            return result;
        }
    }
}

