/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_Service;
import org.jclouds.openstack.poppy.v1.domain.Caching;
import org.jclouds.openstack.poppy.v1.domain.Domain;
import org.jclouds.openstack.poppy.v1.domain.Error;
import org.jclouds.openstack.poppy.v1.domain.Origin;
import org.jclouds.openstack.poppy.v1.domain.Restriction;
import org.jclouds.openstack.poppy.v1.domain.ServiceStatus;
import org.jclouds.openstack.poppy.v1.domain.UpdateService;
import org.jclouds.openstack.v2_0.domain.Link;

public abstract class Service {
    public abstract String getId();

    public abstract String getName();

    public abstract List<Domain> getDomains();

    public abstract List<Origin> getOrigins();

    @Nullable
    public abstract List<Caching> getCaching();

    @Nullable
    public abstract List<Restriction> getRestrictions();

    @Nullable
    public abstract String getFlavorId();

    public abstract ServiceStatus getStatus();

    @Nullable
    public abstract List<Error> getErrors();

    public abstract Set<Link> getLinks();

    @SerializedNames(value={"id", "name", "domains", "origins", "caching", "restrictions", "flavor_id", "status", "errors", "links"})
    private static Service create(String id, String name, List<Domain> domains, List<Origin> origins, List<Caching> caching, List<Restriction> restrictions, String flavorId, ServiceStatus status, List<Error> errors, Set<Link> links) {
        return new AutoValue_Service(id, name, (List<Domain>)ImmutableList.copyOf(domains), (List<Origin>)ImmutableList.copyOf(origins), (List<Caching>)(caching != null ? ImmutableList.copyOf(caching) : null), (List<Restriction>)(restrictions != null ? ImmutableList.copyOf(restrictions) : null), flavorId, status, (List<Error>)(errors != null ? ImmutableList.copyOf(errors) : null), (Set<Link>)ImmutableSet.copyOf(links));
    }

    public UpdateService.Builder toUpdatableService() {
        return UpdateService.builder().name(this.getName()).domains(this.getDomains()).origins(this.getOrigins()).caching(this.getCaching()).restrictions(this.getRestrictions()).flavorId(this.getFlavorId());
    }
}

