/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_UpdateService;
import org.jclouds.openstack.poppy.v1.domain.Caching;
import org.jclouds.openstack.poppy.v1.domain.Domain;
import org.jclouds.openstack.poppy.v1.domain.Origin;
import org.jclouds.openstack.poppy.v1.domain.Restriction;

public abstract class UpdateService {
    public abstract String getName();

    public abstract List<Domain> getDomains();

    public abstract List<Origin> getOrigins();

    @Nullable
    public abstract List<Caching> getCaching();

    @Nullable
    public abstract List<Restriction> getRestrictions();

    public abstract String getFlavorId();

    public static Builder builder() {
        return new Builder().caching(null).restrictions(null);
    }

    public Builder toBuilder() {
        return UpdateService.builder().name(this.getName()).domains(this.getDomains()).origins(this.getOrigins()).caching(this.getCaching()).restrictions(this.getRestrictions()).flavorId(this.getFlavorId());
    }

    @SerializedNames(value={"name", "domains", "origins", "caching", "restrictions", "flavor_id"})
    private static UpdateService create(String name, List<Domain> domains, List<Origin> origins, List<Caching> caching, List<Restriction> restrictions, String flavorId) {
        return UpdateService.builder().name(name).domains(domains).origins(origins).caching(caching).restrictions(restrictions).flavorId(flavorId).build();
    }

    public static final class Builder {
        private String name;
        private List<Domain> domains;
        private List<Origin> origins;
        private List<Caching> caching;
        private List<Restriction> restrictions;
        private String flavorId;

        Builder() {
        }

        Builder(UpdateService source) {
            this.name(source.getName());
            this.domains(source.getDomains());
            this.origins(source.getOrigins());
            this.caching(source.getCaching());
            this.restrictions(source.getRestrictions());
            this.flavorId(source.getFlavorId());
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder domains(List<Domain> domains) {
            this.domains = domains;
            return this;
        }

        public Builder origins(List<Origin> origins) {
            this.origins = origins;
            return this;
        }

        public Builder caching(List<Caching> caching) {
            this.caching = caching;
            return this;
        }

        public Builder restrictions(List<Restriction> restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public Builder flavorId(String flavorId) {
            this.flavorId = flavorId;
            return this;
        }

        public UpdateService build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.domains == null) {
                missing = missing + " domains";
            }
            if (this.origins == null) {
                missing = missing + " origins";
            }
            if (this.flavorId == null) {
                missing = missing + " flavorId";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_UpdateService result = new AutoValue_UpdateService(this.name, this.domains, this.origins, (List<Caching>)(this.caching != null ? ImmutableList.copyOf(this.caching) : null), (List<Restriction>)(this.restrictions != null ? ImmutableList.copyOf(this.restrictions) : null), this.flavorId);
            return result;
        }
    }
}

