/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.features;

import com.google.common.annotations.Beta;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.poppy.v1.config.CDN;
import org.jclouds.openstack.poppy.v1.domain.CreateService;
import org.jclouds.openstack.poppy.v1.domain.Service;
import org.jclouds.openstack.poppy.v1.domain.UpdateService;
import org.jclouds.openstack.poppy.v1.functions.ParseServiceURIFromHeaders;
import org.jclouds.openstack.poppy.v1.functions.ParseServices;
import org.jclouds.openstack.poppy.v1.functions.ServicesToPagedIterable;
import org.jclouds.openstack.poppy.v1.mapbinders.JSONPatchUpdate;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Endpoint(value=CDN.class)
@Path(value="/services")
@Beta
public interface ServiceApi {
    @Named(value="service:list")
    @GET
    @ResponseParser(value=ParseServices.class)
    @Transform(value=ServicesToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Service> list();

    @Named(value="service:list")
    @GET
    @ResponseParser(value=ParseServices.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Service> list(PaginationOptions var1);

    @Named(value="service:get")
    @GET
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Service get(@PathParam(value="id") String var1);

    @Named(value="service:create")
    @POST
    @ResponseParser(value=ParseServiceURIFromHeaders.class)
    @Produces(value={"application/json"})
    @Nullable
    public URI create(@BinderParam(value=BindToJsonPayload.class) CreateService var1);

    @Named(value="service:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="service:update")
    @PATCH
    @Path(value="/{id}")
    @ResponseParser(value=ParseServiceURIFromHeaders.class)
    @MapBinder(value=JSONPatchUpdate.class)
    @Nullable
    public URI update(@PathParam(value="id") String var1, @PayloadParam(value="service") Service var2, @PayloadParam(value="updateService") UpdateService var3);

    @Named(value="service:deleteAsset")
    @DELETE
    @Path(value="/{id}/assets")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteAsset(@PathParam(value="id") String var1, @QueryParam(value="url") String var2);

    @Named(value="service:deleteAssets")
    @DELETE
    @Path(value="/{id}/assets")
    @QueryParams(keys={"all"}, values={"true"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteAssets(@PathParam(value="id") String var1);
}

