/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.poppy.v1.PoppyApi;
import org.jclouds.openstack.poppy.v1.domain.Service;
import org.jclouds.openstack.poppy.v1.features.ServiceApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class ServicesToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Service, ServicesToPagedIterable> {
    private final PoppyApi api;

    @Inject
    protected ServicesToPagedIterable(PoppyApi api) {
        this.api = (PoppyApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Service>> markerToNextForArg0(Optional<Object> arg0) {
        final ServiceApi serviceApi = this.api.getServiceApi();
        return new Function<Object, IterableWithMarker<Service>>(){

            public IterableWithMarker<Service> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast(serviceApi.list(paginationOptions));
            }

            public String toString() {
                return "listServices()";
            }
        };
    }
}

