/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.mapbinders;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.poppy.v1.domain.Service;
import org.jclouds.rest.MapBinder;

public class JSONPatchUpdate
implements MapBinder {
    @Inject
    Json json;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        String jsonPatch = null;
        Service service = (Service)postParams.get("service");
        String targetService = this.json.toJson(postParams.get("updateService"));
        String sourceService = this.json.toJson((Object)service.toUpdatableService().build());
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonPatch = JsonDiff.asJson((JsonNode)mapper.readTree(sourceService), (JsonNode)mapper.readTree(targetService)).toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create a JSONPatch", e);
        }
        return this.bindToRequest(request, jsonPatch);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        request.setPayload((String)input);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }
}

