/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.poppy.v1.domain.Service;
import org.jclouds.openstack.poppy.v1.domain.ServiceStatus;
import org.jclouds.openstack.poppy.v1.features.ServiceApi;
import org.jclouds.util.Predicates2;

public class ServicePredicates {
    public static Predicate<Service> awaitDeployed(ServiceApi serviceApi) {
        ServiceStatusPredicate statusPredicate = new ServiceStatusPredicate(serviceApi, ServiceStatus.DEPLOYED);
        return Predicates2.retry((Predicate)statusPredicate, (long)1200L, (long)15L, (long)15L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static class ServiceStatusPredicate
    implements Predicate<Service> {
        private ServiceApi serviceApi;
        private ServiceStatus status;

        public ServiceStatusPredicate(ServiceApi instanceApi, ServiceStatus status) {
            this.serviceApi = (ServiceApi)Preconditions.checkNotNull((Object)instanceApi, (Object)"serviceApi must be defined");
            this.status = (ServiceStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must be defined"));
        }

        public boolean apply(Service service) {
            Preconditions.checkNotNull((Object)service, (Object)"service must be defined");
            if (this.status.equals((Object)service.getStatus())) {
                return true;
            }
            Service serviceUpdated = this.serviceApi.get(service.getId());
            Preconditions.checkNotNull((Object)serviceUpdated, (String)"service %s not found.", (Object[])new Object[]{service.getId()});
            return this.status.equals((Object)serviceUpdated.getStatus());
        }
    }
}

