/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1;

import com.google.common.base.Optional;
import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.rackspace.autoscale.v1.features.GroupApi;
import org.jclouds.rackspace.autoscale.v1.features.PolicyApi;
import org.jclouds.rackspace.autoscale.v1.features.WebhookApi;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

public interface AutoscaleApi
extends Closeable {
    @Provides
    @Region
    public Set<String> getConfiguredRegions();

    @Delegate
    public GroupApi getGroupApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    @Path(value="/groups/{groupId}")
    public PolicyApi getPolicyApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="groupId") String var2);

    @Delegate
    @Path(value="/groups/{groupId}/policies/{policyId}")
    public WebhookApi getWebhookApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="groupId") String var2, @PathParam(value="policyId") String var3);

    @Provides
    public Optional<Tenant> getCurrentTenantId();

    @Deprecated
    @Provides
    @Region
    public Set<String> getConfiguredZones();

    @Deprecated
    @Delegate
    @Path(value="/groups/{groupId}")
    public PolicyApi getPolicyApiForGroup(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="groupId") String var2);

    @Deprecated
    @Delegate
    @Path(value="/groups/{groupId}/policies/{policyId}")
    public WebhookApi getWebhookApiForGroupAndPolicy(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="groupId") String var2, @PathParam(value="policyId") String var3);
}

