/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.rackspace.autoscale.v1.AutoscaleApi;
import org.jclouds.rackspace.autoscale.v1.config.AutoscaleHttpApiModule;
import org.jclouds.rackspace.autoscale.v1.config.AutoscaleParserModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationApiModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public class AutoscaleApiMetadata
extends BaseHttpApiMetadata<AutoscaleApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public AutoscaleApiMetadata() {
        this(new Builder());
    }

    protected AutoscaleApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "rax:autoscale");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<AutoscaleApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("rackspace-autoscale")).name("Rackspace Autoscale API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base URL ending in /v2.0/")).documentation(URI.create("http://api.openstack.org/"))).version("1.0")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(AutoscaleApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(CloudIdentityAuthenticationApiModule.class).add(CloudIdentityAuthenticationModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(AutoscaleParserModule.class).add(AutoscaleHttpApiModule.class).build());
        }

        public AutoscaleApiMetadata build() {
            return new AutoscaleApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

