/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rackspace.autoscale.v1.domain.GroupConfiguration;
import org.jclouds.rackspace.autoscale.v1.internal.ParseHelper;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindCreateGroupToJson
implements MapBinder {
    private final BindToJsonPayload jsonBinder;

    @Inject
    private BindCreateGroupToJson(BindToJsonPayload jsonBinder) {
        this.jsonBinder = jsonBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ImmutableMap<String, Object> launchConfigurationMap = ParseHelper.buildLaunchConfigurationRequestMap(postParams);
        GroupConfiguration groupConfiguration = (GroupConfiguration)postParams.get("groupConfiguration");
        ImmutableList<Map<String, Object>> scalingPoliciesList = ParseHelper.buildScalingPoliciesRequestList(postParams);
        return (R)this.jsonBinder.bindToRequest(request, (Map)ImmutableMap.of((Object)"launchConfiguration", launchConfigurationMap, (Object)"groupConfiguration", (Object)groupConfiguration, (Object)"scalingPolicies", scalingPoliciesList));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("Create scaling group is a POST operation");
    }
}

