/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.binders;

import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.internal.ParseHelper;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindScalingPolicyToJson
implements MapBinder {
    private final BindToJsonPayload jsonBinder;

    @Inject
    private BindScalingPolicyToJson(BindToJsonPayload jsonBinder) {
        this.jsonBinder = jsonBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        CreateScalingPolicy scalingPolicy = (CreateScalingPolicy)postParams.get("scalingPolicy");
        return (R)this.jsonBinder.bindToRequest(request, ParseHelper.buildScalingPolicyMap(scalingPolicy));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("Update policy is a POST operation");
    }
}

