/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rackspace.autoscale.v1.domain.GroupConfiguration;
import org.jclouds.rest.MapBinder;

public class BindToGroupConfigurationRequestPayload
implements MapBinder {
    protected final Json jsonBinder;

    @Inject
    public BindToGroupConfigurationRequestPayload(Json jsonBinder) {
        this.jsonBinder = (Json)Preconditions.checkNotNull((Object)jsonBinder, (Object)"jsonBinder");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        GroupConfiguration gc = (GroupConfiguration)postParams.get("groupConfiguration");
        HashMap gcMap = Maps.newHashMap();
        gcMap.put("name", gc.getName());
        gcMap.put("cooldown", gc.getCooldown());
        gcMap.put("minEntities", gc.getMinEntities());
        gcMap.put("maxEntities", gc.getMaxEntities());
        gcMap.put("metadata", gc.getMetadata());
        request.setPayload(this.jsonBinder.toJson((Object)gcMap));
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("Illegal unwrap operation");
    }
}

