/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rackspace.autoscale.v1.domain.CreateWebhook;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindWebhooksToJson
implements MapBinder {
    private final BindToJsonPayload jsonBinder;

    @Inject
    private BindWebhooksToJson(BindToJsonPayload jsonBinder) {
        this.jsonBinder = jsonBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ImmutableList.Builder webhookListBuilder = ImmutableList.builder();
        for (CreateWebhook webhook : (List)postParams.get("webhooks")) {
            ImmutableMap.Builder webhookMap = ImmutableMap.builder();
            webhookMap.put((Object)"name", (Object)webhook.getName());
            if (!webhook.getMetadata().isEmpty()) {
                webhookMap.put((Object)"metadata", webhook.getMetadata());
            }
            webhookListBuilder.add((Object)webhookMap.build());
        }
        return (R)this.jsonBinder.bindToRequest(request, (Object)webhookListBuilder.build());
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("Create webhook is a POST operation");
    }
}

