/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.rackspace.autoscale.v1.AutoscaleApi;
import org.jclouds.rackspace.autoscale.v1.handlers.AutoscaleErrorHandler;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class AutoscaleHttpApiModule
extends HttpApiModule<AutoscaleApi> {
    protected void configure() {
        super.configure();
    }

    @Provides
    @Singleton
    public Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(AutoscaleErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(AutoscaleErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(AutoscaleErrorHandler.class);
    }

    @Provides
    Supplier<Optional<Tenant>> supplyTenant(Supplier<Access> access) {
        return Suppliers.compose((Function)GetTenant.INSTANCE, access);
    }

    private static enum GetTenant implements Function<Access, Optional<Tenant>>
    {
        INSTANCE;


        public Optional<Tenant> apply(Access in) {
            return in.getToken().getTenant();
        }
    }
}

