/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;

public class CreateScalingPolicy
implements Comparable<CreateScalingPolicy> {
    private final String name;
    private final ScalingPolicyType type;
    private final int cooldown;
    private final String target;
    private final ScalingPolicyTargetType targetType;
    private final Map<String, String> args;

    @ConstructorProperties(value={"name", "type", "cooldown", "target", "targetType", "args"})
    protected CreateScalingPolicy(String name, ScalingPolicyType type, int cooldown, String target, ScalingPolicyTargetType targetType, Map<String, String> args) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name required");
        this.type = type;
        Preconditions.checkArgument((cooldown >= 0 ? 1 : 0) != 0, (Object)"cooldown should be non-negative");
        this.cooldown = cooldown;
        this.target = target;
        this.targetType = targetType;
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public ScalingPolicyType getType() {
        return this.type;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public String getTarget() {
        return this.target;
    }

    public ScalingPolicyTargetType getTargetType() {
        return this.targetType;
    }

    protected Map<String, String> getSchedulingArgs() {
        return this.args;
    }

    public String getSchedulingString() {
        Iterator<Map.Entry<String, String>> i$;
        if (this.args != null && (i$ = this.args.entrySet().iterator()).hasNext()) {
            Map.Entry<String, String> entry = i$.next();
            return entry.getValue();
        }
        return null;
    }

    public ScalingPolicyScheduleType getSchedulingType() {
        if (this.args != null) {
            for (ScalingPolicyScheduleType type : ScalingPolicyScheduleType.values()) {
                if (this.args.get(type.toString()) == null) continue;
                return type;
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.cooldown, this.target, this.targetType, this.args});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateScalingPolicy that = (CreateScalingPolicy)CreateScalingPolicy.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.cooldown, (Object)that.cooldown) && Objects.equal((Object)this.target, (Object)that.target) && Objects.equal((Object)((Object)this.targetType), (Object)((Object)that.targetType)) && Objects.equal(this.args, that.args);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("cooldown", this.cooldown).add("target", (Object)this.target).add("targetType", (Object)this.targetType).add("args", this.args);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromScalingPolicy(this);
    }

    @Override
    public int compareTo(CreateScalingPolicy that) {
        return this.getName().compareTo(that.getName());
    }

    public static enum ScalingPolicyScheduleType {
        AT("at"),
        CRON("cron");

        private final String name;

        private ScalingPolicyScheduleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Optional<ScalingPolicyTargetType> getByValue(String value) {
            for (ScalingPolicyTargetType element : EnumSet.allOf(ScalingPolicyTargetType.class)) {
                if (!element.toString().equals(value)) continue;
                return Optional.of((Object)((Object)element));
            }
            return Optional.absent();
        }
    }

    public static enum ScalingPolicyTargetType {
        INCREMENTAL("change"),
        DESIRED_CAPACITY("desiredCapacity"),
        PERCENT_CHANGE("changePercent");

        private final String name;

        private ScalingPolicyTargetType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Optional<ScalingPolicyTargetType> getByValue(String value) {
            for (ScalingPolicyTargetType element : EnumSet.allOf(ScalingPolicyTargetType.class)) {
                if (!element.toString().equals(value)) continue;
                return Optional.of((Object)((Object)element));
            }
            return Optional.absent();
        }
    }

    public static enum ScalingPolicyType {
        WEBHOOK("webhook"),
        SCHEDULE("schedule");

        private final String name;

        private ScalingPolicyType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Optional<ScalingPolicyType> getByValue(String value) {
            for (ScalingPolicyType element : EnumSet.allOf(ScalingPolicyType.class)) {
                if (!element.toString().equals(value)) continue;
                return Optional.of((Object)((Object)element));
            }
            return Optional.absent();
        }
    }

    public static class Builder {
        protected String name;
        protected ScalingPolicyType type;
        protected int cooldown;
        protected String target;
        protected ScalingPolicyTargetType targetType;
        protected Map<String, String> args;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(ScalingPolicyType type) {
            this.type = type;
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder targetType(ScalingPolicyTargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder cronSchedule(String cron) {
            this.type = ScalingPolicyType.SCHEDULE;
            this.args = ImmutableMap.of((Object)"cron", (Object)cron);
            return this;
        }

        public Builder atSchedule(String at) {
            this.type = ScalingPolicyType.SCHEDULE;
            this.args = ImmutableMap.of((Object)"at", (Object)at);
            return this;
        }

        private Builder scheduleArgs(Map<String, String> args) {
            this.args = args;
            return this;
        }

        public CreateScalingPolicy build() {
            return new CreateScalingPolicy(this.name, this.type, this.cooldown, this.target, this.targetType, this.args);
        }

        public Builder fromScalingPolicy(CreateScalingPolicy in) {
            return this.name(in.getName()).type(in.getType()).cooldown(in.getCooldown()).target(in.getTarget()).targetType(in.getTargetType()).scheduleArgs(in.getSchedulingArgs());
        }
    }
}

