/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class CreateWebhook {
    private final String name;
    private final ImmutableMap<String, Object> metadata;

    @ConstructorProperties(value={"name", "metadata"})
    protected CreateWebhook(String name, @Nullable Map<String, Object> metadata) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    public String getName() {
        return this.name;
    }

    public ImmutableMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateWebhook that = (CreateWebhook)CreateWebhook.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.metadata, that.metadata);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromWebhook(this);
    }

    public static class Builder {
        protected String name;
        protected Map<String, Object> metadata;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CreateWebhook build() {
            return new CreateWebhook(this.name, this.metadata);
        }

        public Builder fromWebhook(CreateWebhook in) {
            return this.name(in.getName()).metadata((Map<String, Object>)in.getMetadata());
        }
    }
}

