/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.autoscale.v1.domain.GroupConfiguration;
import org.jclouds.rackspace.autoscale.v1.domain.LaunchConfiguration;
import org.jclouds.rackspace.autoscale.v1.domain.ScalingPolicy;

public class Group {
    private final String id;
    private final ImmutableList<Link> links;
    private final ImmutableList<ScalingPolicy> scalingPolicy;
    private final GroupConfiguration groupConfiguration;
    private final LaunchConfiguration launchConfiguration;

    protected Group(String id, ImmutableList<Link> links, ImmutableList<ScalingPolicy> scalingPolicy, GroupConfiguration groupConfiguration, LaunchConfiguration launchConfiguration) {
        this.id = id;
        this.links = links;
        this.scalingPolicy = scalingPolicy;
        this.groupConfiguration = groupConfiguration;
        this.launchConfiguration = launchConfiguration;
    }

    public String getId() {
        return this.id;
    }

    public ImmutableList<Link> getLinks() {
        return this.links;
    }

    public ImmutableList<ScalingPolicy> getScalingPolicies() {
        return this.scalingPolicy;
    }

    public GroupConfiguration getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public LaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.links, this.scalingPolicy, this.groupConfiguration, this.launchConfiguration});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Group that = (Group)Group.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.links, that.links) && Objects.equal(this.scalingPolicy, that.scalingPolicy) && Objects.equal((Object)this.groupConfiguration, (Object)that.groupConfiguration) && Objects.equal((Object)this.launchConfiguration, (Object)that.launchConfiguration);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("links", this.links).add("scalingPolicy", this.scalingPolicy).add("groupConfiguration", (Object)this.groupConfiguration).add("launchConfiguration", (Object)"launchConfiguration");
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromGroup(this);
    }

    public static class Builder {
        protected String id;
        protected ImmutableList<Link> links;
        protected ImmutableList<ScalingPolicy> scalingPolicy;
        protected GroupConfiguration groupConfiguration;
        protected LaunchConfiguration launchConfiguration;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder links(List<Link> links) {
            this.links = ImmutableList.copyOf(links);
            return this;
        }

        public Builder scalingPolicy(List<ScalingPolicy> scalingPolicy) {
            this.scalingPolicy = ImmutableList.copyOf(scalingPolicy);
            return this;
        }

        public Builder groupConfiguration(GroupConfiguration groupConfiguration) {
            this.groupConfiguration = groupConfiguration;
            return this;
        }

        public Builder launchConfiguration(LaunchConfiguration launchConfiguration) {
            this.launchConfiguration = launchConfiguration;
            return this;
        }

        public Group build() {
            return new Group(this.id, this.links, this.scalingPolicy, this.groupConfiguration, this.launchConfiguration);
        }

        public Builder fromGroup(Group in) {
            return this.id(in.getId()).links((List<Link>)in.getLinks()).scalingPolicy((List<ScalingPolicy>)in.getScalingPolicies()).groupConfiguration(in.getGroupConfiguration()).launchConfiguration(in.getLaunchConfiguration());
        }
    }
}

