/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;

public class GroupConfiguration
implements Comparable<GroupConfiguration> {
    private final String name;
    private final int cooldown;
    private final int minEntities;
    private final int maxEntities;
    private final ImmutableMap<String, String> metadata;

    @ConstructorProperties(value={"name", "cooldown", "minEntities", "maxEntities", "metadata"})
    protected GroupConfiguration(String name, int cooldown, int minEntities, int maxEntities, Map<String, String> metadata) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name required");
        Preconditions.checkArgument((cooldown >= 0 ? 1 : 0) != 0, (Object)"cooldown should be non-negative");
        Preconditions.checkArgument((minEntities >= 0 ? 1 : 0) != 0, (Object)"minEntities should be non-negative");
        Preconditions.checkArgument((maxEntities >= 0 ? 1 : 0) != 0, (Object)"maxEntities should be non-negative");
        this.cooldown = cooldown;
        this.minEntities = minEntities;
        this.maxEntities = maxEntities;
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    public String getName() {
        return this.name;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMinEntities() {
        return this.minEntities;
    }

    public int getMaxEntities() {
        return this.maxEntities;
    }

    public ImmutableMap<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.cooldown, this.minEntities, this.maxEntities, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GroupConfiguration that = (GroupConfiguration)GroupConfiguration.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.cooldown, (Object)that.cooldown) && Objects.equal((Object)this.minEntities, (Object)that.minEntities) && Objects.equal((Object)this.maxEntities, (Object)that.maxEntities) && Objects.equal(this.metadata, that.metadata);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("cooldown", this.cooldown).add("minEntities", this.minEntities).add("maxEntities", this.maxEntities).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromGroupConfiguration(this);
    }

    @Override
    public int compareTo(GroupConfiguration that) {
        return this.getName().compareTo(that.getName());
    }

    public static class Builder {
        protected String name;
        protected int cooldown;
        protected int minEntities;
        protected int maxEntities;
        protected Map<String, String> metadata;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder minEntities(int minEntities) {
            this.minEntities = minEntities;
            return this;
        }

        public Builder maxEntities(int maxEntities) {
            this.maxEntities = maxEntities;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public GroupConfiguration build() {
            return new GroupConfiguration(this.name, this.cooldown, this.minEntities, this.maxEntities, this.metadata);
        }

        public Builder fromGroupConfiguration(GroupConfiguration in) {
            return this.name(in.getName()).cooldown(in.getCooldown()).minEntities(in.getMinEntities()).maxEntities(in.getMaxEntities()).metadata((Map<String, String>)in.getMetadata());
        }
    }
}

