/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.v2_0.domain.Link;

public class GroupInstance {
    private final String id;
    private final ImmutableList<Link> links;

    @ConstructorProperties(value={"id", "links"})
    protected GroupInstance(String id, ImmutableList<Link> links) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id should not be null");
        this.links = (ImmutableList)Preconditions.checkNotNull(links, (Object)"links should not be null");
    }

    public String getId() {
        return this.id;
    }

    public ImmutableList<Link> getLinks() {
        return this.links;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.links, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GroupInstance that = (GroupInstance)GroupInstance.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.links, that.links);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("links", this.links);
    }

    public String toString() {
        return this.string().toString();
    }
}

