/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.autoscale.v1.domain.GroupInstance;

public class GroupState
implements Comparable<GroupState> {
    private final String id;
    private final ImmutableList<Link> links;
    private final int activeCapacity;
    private final int pendingCapacity;
    private final int desiredCapacity;
    private final boolean paused;
    @SerializedName(value="active")
    private final ImmutableList<GroupInstance> groupInstances;

    @ConstructorProperties(value={"id", "links", "activeCapacity", "pendingCapacity", "desiredCapacity", "paused", "active"})
    protected GroupState(String id, List<Link> links, int activeCapacity, int pendingCapacity, int desiredCapacity, boolean paused, List<GroupInstance> groupInstances) {
        this.id = id;
        this.links = links == null ? ImmutableList.of() : ImmutableList.copyOf(links);
        this.activeCapacity = activeCapacity;
        this.pendingCapacity = pendingCapacity;
        this.desiredCapacity = desiredCapacity;
        this.paused = paused;
        this.groupInstances = groupInstances == null ? ImmutableList.of() : ImmutableList.copyOf(groupInstances);
    }

    public String getId() {
        return this.id;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public int getActiveCapacity() {
        return this.activeCapacity;
    }

    public int getPendingCapacity() {
        return this.pendingCapacity;
    }

    public int getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public boolean getPaused() {
        return this.paused;
    }

    public List<GroupInstance> getGroupInstances() {
        return this.groupInstances;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.links, this.activeCapacity, this.pendingCapacity, this.desiredCapacity, this.paused, this.groupInstances});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GroupState that = (GroupState)GroupState.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.activeCapacity, (Object)that.activeCapacity) && Objects.equal((Object)this.pendingCapacity, (Object)that.pendingCapacity) && Objects.equal((Object)this.desiredCapacity, (Object)that.desiredCapacity) && Objects.equal((Object)this.paused, (Object)that.paused) && Objects.equal(this.groupInstances, that.groupInstances);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("links", this.links).add("activeCapacity", this.activeCapacity).add("pendingCapacity", this.pendingCapacity).add("desiredCapacity", (Object)"desiredCapacity").add("paused", (Object)"paused").add("groupInstances", (Object)"groupInstances");
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(GroupState that) {
        return this.getId().compareTo(that.getId());
    }
}

