/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jclouds.rackspace.autoscale.v1.domain.LoadBalancer;
import org.jclouds.rackspace.autoscale.v1.domain.Personality;

public class LaunchConfiguration
implements Comparable<LaunchConfiguration> {
    private final ImmutableList<LoadBalancer> loadBalancers;
    private final LaunchConfigurationType type;
    private final ImmutableList<String> networks;
    private final ImmutableList<Personality> personalities;
    private final String serverName;
    private final String serverImageRef;
    private final String serverFlavorRef;
    private final String serverDiskConfig;
    private final ImmutableMap<String, String> serverMetadata;

    @ConstructorProperties(value={"loadBalancers", "type", "networks", "personalities", "serverName", "serverImageRef", "serverFlavorRef", "serverDiskConfig", "serverMetadata"})
    protected LaunchConfiguration(List<LoadBalancer> loadBalancers, LaunchConfigurationType type, List<String> networks, List<Personality> personalities, String serverName, String serverImageRef, String serverFlavorRef, String serverDiskConfig, Map<String, String> serverMetadata) {
        this.loadBalancers = ImmutableList.copyOf(loadBalancers);
        this.type = type;
        this.networks = ImmutableList.copyOf(networks);
        this.personalities = ImmutableList.copyOf(personalities);
        this.serverName = serverName;
        this.serverImageRef = serverImageRef;
        this.serverFlavorRef = serverFlavorRef;
        this.serverDiskConfig = serverDiskConfig;
        this.serverMetadata = ImmutableMap.copyOf(serverMetadata);
    }

    public List<LoadBalancer> getLoadBalancers() {
        return this.loadBalancers;
    }

    public LaunchConfigurationType getType() {
        return this.type;
    }

    public List<String> getNetworks() {
        return this.networks;
    }

    public List<Personality> getPersonalities() {
        return this.personalities;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerImageRef() {
        return this.serverImageRef;
    }

    public String getServerFlavorRef() {
        return this.serverFlavorRef;
    }

    public String getServerDiskConfig() {
        return this.serverDiskConfig;
    }

    public ImmutableMap<String, String> getServerMetadata() {
        return this.serverMetadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.loadBalancers, this.type, this.networks, this.personalities, this.serverName, this.serverImageRef, this.serverFlavorRef, this.serverDiskConfig, this.serverMetadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchConfiguration that = (LaunchConfiguration)LaunchConfiguration.class.cast(obj);
        return Objects.equal(this.loadBalancers, that.loadBalancers) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal(this.networks, that.networks) && Objects.equal(this.personalities, that.personalities) && Objects.equal((Object)this.serverName, (Object)that.serverName) && Objects.equal((Object)this.serverImageRef, (Object)that.serverImageRef) && Objects.equal((Object)this.serverFlavorRef, (Object)that.serverFlavorRef) && Objects.equal((Object)this.serverDiskConfig, (Object)that.serverDiskConfig) && Objects.equal(this.serverMetadata, that.serverMetadata);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("loadBalancers", this.loadBalancers).add("type", (Object)this.type).add("networks", this.networks).add("personalities", this.personalities).add("serverName", (Object)this.serverName).add("serverImageRef", (Object)this.serverImageRef).add("serverFlavorRef", (Object)this.serverFlavorRef).add("serverDiskConfig", (Object)this.serverDiskConfig).add("serverMetadata", this.serverMetadata);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromLaunchConfiguration(this);
    }

    @Override
    public int compareTo(LaunchConfiguration that) {
        return this.getServerName().compareTo(that.getServerName());
    }

    public static enum LaunchConfigurationType {
        LAUNCH_SERVER("launch_server");

        private final String name;

        private LaunchConfigurationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Optional<LaunchConfigurationType> getByValue(String value) {
            for (LaunchConfigurationType element : EnumSet.allOf(LaunchConfigurationType.class)) {
                if (!element.toString().equals(value)) continue;
                return Optional.of((Object)((Object)element));
            }
            return Optional.absent();
        }
    }

    public static class Builder {
        protected List<LoadBalancer> loadBalancers;
        protected LaunchConfigurationType type;
        protected List<String> networks;
        protected List<Personality> personalities;
        protected String serverName;
        protected String serverImageRef;
        protected String serverFlavorRef;
        protected String serverDiskConfig;
        protected ImmutableMap<String, String> serverMetadata;

        public Builder loadBalancers(List<LoadBalancer> loadBalancers) {
            this.loadBalancers = loadBalancers;
            return this;
        }

        public Builder type(LaunchConfigurationType type) {
            this.type = type;
            return this;
        }

        public Builder networks(List<String> networks) {
            this.networks = networks;
            return this;
        }

        public Builder personalities(List<Personality> personalities) {
            this.personalities = personalities;
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder serverImageRef(String serverImageRef) {
            this.serverImageRef = serverImageRef;
            return this;
        }

        public Builder serverFlavorRef(String serverFlavorRef) {
            this.serverFlavorRef = serverFlavorRef;
            return this;
        }

        public Builder serverDiskConfig(String serverDiskConfig) {
            this.serverDiskConfig = serverDiskConfig;
            return this;
        }

        public Builder serverMetadata(Map<String, String> serverMetadata) {
            this.serverMetadata = ImmutableMap.copyOf(serverMetadata);
            return this;
        }

        public LaunchConfiguration build() {
            return new LaunchConfiguration(this.loadBalancers, this.type, this.networks, this.personalities, this.serverName, this.serverImageRef, this.serverFlavorRef, this.serverDiskConfig, (Map<String, String>)this.serverMetadata);
        }

        public Builder fromLaunchConfiguration(LaunchConfiguration in) {
            return this.loadBalancers(in.getLoadBalancers()).type(in.getType()).networks(in.getNetworks()).personalities(in.getPersonalities()).serverName(in.getServerName()).serverImageRef(in.getServerImageRef()).serverFlavorRef(in.getServerFlavorRef()).serverDiskConfig(in.getServerDiskConfig()).serverMetadata((Map<String, String>)in.getServerMetadata());
        }
    }
}

