/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;

public class LoadBalancer {
    private final int port;
    @SerializedName(value="loadBalancerId")
    private final int id;

    @ConstructorProperties(value={"port", "loadBalancerId"})
    protected LoadBalancer(int port, int id) {
        Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (Object)"port should be non-negative");
        this.port = port;
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id should be non-negative");
        this.id = id;
    }

    public int getPort() {
        return this.port;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.port, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer that = (LoadBalancer)LoadBalancer.class.cast(obj);
        return Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("port", this.port).add("id", this.id);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromLoadBalancer(this);
    }

    public static class Builder {
        protected int port;
        protected int id;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.port, this.id);
        }

        public Builder fromLoadBalancer(LoadBalancer in) {
            return this.port(in.getPort()).id(in.getId());
        }
    }
}

