/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Personality {
    private final String path;
    private final String contents;

    @ConstructorProperties(value={"path", "contents"})
    protected Personality(String path, String contents) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        this.contents = (String)Preconditions.checkNotNull((Object)contents, (Object)"contents should not be null");
    }

    public String getPath() {
        return this.path;
    }

    public String getContents() {
        return this.contents;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.contents});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Personality that = (Personality)Personality.class.cast(obj);
        return Objects.equal((Object)this.path, (Object)that.path) && Objects.equal((Object)this.contents, (Object)that.contents);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("path", (Object)this.path).add("contents", (Object)this.contents);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromPersonality(this);
    }

    public static class Builder {
        protected String path;
        protected String contents;

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder contents(String contents) {
            this.contents = contents;
            return this;
        }

        public Personality build() {
            return new Personality(this.path, this.contents);
        }

        public Builder fromPersonality(Personality in) {
            return this.path(in.getPath()).contents(in.getContents());
        }
    }
}

