/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;

public class ScalingPolicy
extends CreateScalingPolicy {
    private final ImmutableList<Link> links;
    private final String id;

    @ConstructorProperties(value={"name", "type", "cooldown", "target", "targetType", "args", "links", "id"})
    public ScalingPolicy(String name, CreateScalingPolicy.ScalingPolicyType type, int cooldown, String target, CreateScalingPolicy.ScalingPolicyTargetType targetType, Map<String, String> args, List<Link> links, String id) {
        super(name, type, cooldown, target, targetType, args);
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id required");
        this.links = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(links, (Object)"links required")));
    }

    public String getId() {
        return this.id;
    }

    public ImmutableList<Link> getLinks() {
        return this.links;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.links, this.id});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScalingPolicy that = (ScalingPolicy)ScalingPolicy.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.links, that.links) && super.equals(obj);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("links", this.links).add("id", (Object)this.id);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }
}

