/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.features;

import com.google.common.collect.FluentIterable;
import java.io.Closeable;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.autoscale.v1.binders.BindCreateGroupToJson;
import org.jclouds.rackspace.autoscale.v1.binders.BindLaunchConfigurationToJson;
import org.jclouds.rackspace.autoscale.v1.binders.BindToGroupConfigurationRequestPayload;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.domain.Group;
import org.jclouds.rackspace.autoscale.v1.domain.GroupConfiguration;
import org.jclouds.rackspace.autoscale.v1.domain.GroupState;
import org.jclouds.rackspace.autoscale.v1.domain.LaunchConfiguration;
import org.jclouds.rackspace.autoscale.v1.functions.ParseGroupLaunchConfigurationResponse;
import org.jclouds.rackspace.autoscale.v1.functions.ParseGroupResponse;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/groups")
public interface GroupApi
extends Closeable {
    @Named(value="group:create")
    @POST
    @MapBinder(value=BindCreateGroupToJson.class)
    @ResponseParser(value=ParseGroupResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Group create(@PayloadParam(value="groupConfiguration") GroupConfiguration var1, @PayloadParam(value="launchConfiguration") LaunchConfiguration var2, @PayloadParam(value="scalingPolicies") List<CreateScalingPolicy> var3);

    @Named(value="group:pause")
    @POST
    @Path(value="/{groupId}/pause")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean pause(@PathParam(value="groupId") String var1);

    @Named(value="group:resume")
    @POST
    @Path(value="/{groupId}/resume")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean resume(@PathParam(value="groupId") String var1);

    @Named(value="group:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="group:get")
    @GET
    @Path(value="/{id}")
    @ResponseParser(value=ParseGroupResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Group get(@PathParam(value="id") String var1);

    @Named(value="group:getState")
    @GET
    @Path(value="/{id}/state")
    @SelectJson(value={"group"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public GroupState getState(@PathParam(value="id") String var1);

    @Named(value="group:listGroupStates")
    @GET
    @SelectJson(value={"groups"})
    public FluentIterable<GroupState> listGroupStates();

    @Named(value="group:getGroupConfiguration")
    @GET
    @Path(value="/{groupId}/config")
    @SelectJson(value={"groupConfiguration"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public GroupConfiguration getGroupConfiguration(@PathParam(value="groupId") String var1);

    @Named(value="group:updateGroupConfiguration")
    @PUT
    @Path(value="/{groupId}/config")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @MapBinder(value=BindToGroupConfigurationRequestPayload.class)
    public boolean updateGroupConfiguration(@PathParam(value="groupId") String var1, @PayloadParam(value="groupConfiguration") GroupConfiguration var2);

    @Named(value="group:getLaunchConfiguration")
    @GET
    @Path(value="/{groupId}/launch")
    @ResponseParser(value=ParseGroupLaunchConfigurationResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public LaunchConfiguration getLaunchConfiguration(@PathParam(value="groupId") String var1);

    @Named(value="group:updateLaunchConfiguration")
    @PUT
    @Path(value="/{groupId}/launch")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @MapBinder(value=BindLaunchConfigurationToJson.class)
    public boolean updateLaunchConfiguration(@PathParam(value="groupId") String var1, @PayloadParam(value="launchConfiguration") LaunchConfiguration var2);
}

