/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.features;

import com.google.common.collect.FluentIterable;
import java.io.Closeable;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.autoscale.v1.binders.BindScalingPoliciesToJson;
import org.jclouds.rackspace.autoscale.v1.binders.BindScalingPolicyToJson;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.domain.ScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.functions.ParseScalingPoliciesResponse;
import org.jclouds.rackspace.autoscale.v1.functions.ParseScalingPolicyResponse;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/policies")
public interface PolicyApi
extends Closeable {
    @Named(value="policy:create")
    @POST
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @MapBinder(value=BindScalingPoliciesToJson.class)
    @ResponseParser(value=ParseScalingPoliciesResponse.class)
    public FluentIterable<ScalingPolicy> create(@PayloadParam(value="scalingPolicies") List<CreateScalingPolicy> var1);

    @Named(value="policy:list")
    @GET
    @ResponseParser(value=ParseScalingPoliciesResponse.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<ScalingPolicy> list();

    @Named(value="policy:get")
    @GET
    @Path(value="/{scalingPolicyId}")
    @ResponseParser(value=ParseScalingPolicyResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ScalingPolicy get(@PathParam(value="scalingPolicyId") String var1);

    @Named(value="policy:update")
    @PUT
    @Path(value="/{scalingPolicyId}")
    @MapBinder(value=BindScalingPolicyToJson.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean update(@PathParam(value="scalingPolicyId") String var1, @PayloadParam(value="scalingPolicy") CreateScalingPolicy var2);

    @Named(value="policy:delete")
    @DELETE
    @Path(value="/{scalingPolicyId}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="scalingPolicyId") String var1);

    @Named(value="policy:execute")
    @POST
    @Path(value="/{scalingPolicyId}/execute")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean execute(@PathParam(value="scalingPolicyId") String var1);
}

