/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.features;

import com.google.common.collect.FluentIterable;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.autoscale.v1.binders.BindWebhookToJson;
import org.jclouds.rackspace.autoscale.v1.binders.BindWebhookUpdateToJson;
import org.jclouds.rackspace.autoscale.v1.binders.BindWebhooksToJson;
import org.jclouds.rackspace.autoscale.v1.domain.CreateWebhook;
import org.jclouds.rackspace.autoscale.v1.domain.Webhook;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/webhooks")
public interface WebhookApi
extends Closeable {
    @Named(value="Webhook:create")
    @POST
    @SelectJson(value={"webhooks"})
    @MapBinder(value=BindWebhookToJson.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Webhook> create(@PayloadParam(value="name") String var1, @PayloadParam(value="metadata") Map<String, Object> var2);

    @Named(value="webhook:create")
    @POST
    @SelectJson(value={"webhooks"})
    @MapBinder(value=BindWebhooksToJson.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Webhook> create(@PayloadParam(value="webhooks") List<CreateWebhook> var1);

    @Named(value="Webhook:list")
    @GET
    @SelectJson(value={"webhooks"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Webhook> list();

    @Named(value="webhook:get")
    @GET
    @Path(value="/{webhookId}")
    @SelectJson(value={"webhook"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Webhook get(@PathParam(value="webhookId") String var1);

    @Named(value="webhook:update")
    @PUT
    @Path(value="/{webhookId}")
    @MapBinder(value=BindWebhookUpdateToJson.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean update(@PathParam(value="webhookId") String var1, @PayloadParam(value="name") String var2, @PayloadParam(value="metadata") Map<String, Object> var3);

    @Named(value="webhook:delete")
    @DELETE
    @Path(value="/{webhookId}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="webhookId") String var1);
}

