/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.autoscale.v1.domain.LaunchConfiguration;
import org.jclouds.rackspace.autoscale.v1.domain.LoadBalancer;
import org.jclouds.rackspace.autoscale.v1.domain.Personality;

public class ParseGroupLaunchConfigurationResponse
implements Function<HttpResponse, LaunchConfiguration> {
    private final ParseJson<Map<String, Object>> json;

    @Inject
    ParseGroupLaunchConfigurationResponse(ParseJson<Map<String, Object>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public LaunchConfiguration apply(HttpResponse from) {
        Map result = (Map)this.json.apply(from);
        Map launchConfigurationMap = (Map)result.get("launchConfiguration");
        Map args = (Map)launchConfigurationMap.get("args");
        Map server = (Map)args.get("server");
        ImmutableList.Builder personalities = ImmutableList.builder();
        ImmutableList.Builder networks = ImmutableList.builder();
        for (Map jsonPersonality : (List)server.get("personality")) {
            personalities.add((Object)Personality.builder().path((String)jsonPersonality.get("path")).contents((String)jsonPersonality.get("contents")).build());
        }
        for (Map jsonNetwork : (List)server.get("networks")) {
            networks.add(jsonNetwork.get("uuid"));
        }
        ImmutableList.Builder loadBalancers = ImmutableList.builder();
        for (Map jsonLoadBalancer : (List)args.get("loadBalancers")) {
            loadBalancers.add((Object)LoadBalancer.builder().id(((Double)jsonLoadBalancer.get("loadBalancerId")).intValue()).port(((Double)jsonLoadBalancer.get("port")).intValue()).build());
        }
        LaunchConfiguration launchConfiguration = LaunchConfiguration.builder().loadBalancers((List<LoadBalancer>)loadBalancers.build()).serverName((String)server.get("name")).serverImageRef((String)server.get("imageRef")).serverFlavorRef((String)server.get("flavorRef")).serverDiskConfig((String)server.get("OS-DCF:diskConfig")).serverMetadata((Map)server.get("metadata")).personalities((List<Personality>)personalities.build()).networks((List<String>)networks.build()).type((LaunchConfiguration.LaunchConfigurationType)((Object)LaunchConfiguration.LaunchConfigurationType.getByValue((String)launchConfigurationMap.get("type")).get())).build();
        return launchConfiguration;
    }
}

