/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.domain.Group;
import org.jclouds.rackspace.autoscale.v1.domain.GroupConfiguration;
import org.jclouds.rackspace.autoscale.v1.domain.LaunchConfiguration;
import org.jclouds.rackspace.autoscale.v1.domain.LoadBalancer;
import org.jclouds.rackspace.autoscale.v1.domain.Personality;
import org.jclouds.rackspace.autoscale.v1.domain.ScalingPolicy;

public class ParseGroupResponse
implements Function<HttpResponse, Group> {
    private final ParseJson<Map<String, Object>> json;

    @Inject
    ParseGroupResponse(ParseJson<Map<String, Object>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public Group apply(HttpResponse from) {
        Map result = (Map)this.json.apply(from);
        Map group = (Map)result.get("group");
        Map groupConfigurationMap = (Map)group.get("groupConfiguration");
        Map launchConfigurationMap = (Map)group.get("launchConfiguration");
        ImmutableList.Builder scalingPoliciesList = ImmutableList.builder();
        Map args = (Map)launchConfigurationMap.get("args");
        Map server = (Map)args.get("server");
        ImmutableList.Builder personalities = ImmutableList.builder();
        ImmutableList.Builder networks = ImmutableList.builder();
        for (Map jsonPersonality : (List)server.get("personality")) {
            personalities.add((Object)Personality.builder().path((String)jsonPersonality.get("path")).contents((String)jsonPersonality.get("contents")).build());
        }
        for (Map jsonNetwork : (List)server.get("networks")) {
            networks.add(jsonNetwork.get("uuid"));
        }
        ImmutableList.Builder loadBalancers = ImmutableList.builder();
        for (Map jsonLoadBalancer : (List)args.get("loadBalancers")) {
            loadBalancers.add((Object)LoadBalancer.builder().id(((Double)jsonLoadBalancer.get("loadBalancerId")).intValue()).port(((Double)jsonLoadBalancer.get("port")).intValue()).build());
        }
        LaunchConfiguration launchConfiguration = LaunchConfiguration.builder().loadBalancers((List<LoadBalancer>)loadBalancers.build()).serverName((String)server.get("name")).serverImageRef((String)server.get("imageRef")).serverFlavorRef((String)server.get("flavorRef")).serverDiskConfig((String)server.get("OS-DCF:diskConfig")).serverMetadata((Map)server.get("metadata")).personalities((List<Personality>)personalities.build()).networks((List<String>)networks.build()).type((LaunchConfiguration.LaunchConfigurationType)((Object)LaunchConfiguration.LaunchConfigurationType.getByValue((String)launchConfigurationMap.get("type")).get())).build();
        GroupConfiguration groupConfiguration = GroupConfiguration.builder().cooldown(((Double)groupConfigurationMap.get("cooldown")).intValue()).minEntities(((Double)groupConfigurationMap.get("minEntities")).intValue()).maxEntities(((Double)groupConfigurationMap.get("maxEntities")).intValue()).name((String)groupConfigurationMap.get("name")).metadata((Map)groupConfigurationMap.get("metadata")).build();
        for (Map scalingPolicyMap : (List)group.get("scalingPolicies")) {
            CreateScalingPolicy.ScalingPolicyTargetType targetType = null;
            for (String key : scalingPolicyMap.keySet()) {
                if (!CreateScalingPolicy.ScalingPolicyTargetType.getByValue(key).isPresent()) continue;
                targetType = (CreateScalingPolicy.ScalingPolicyTargetType)((Object)CreateScalingPolicy.ScalingPolicyTargetType.getByValue(key).get());
                break;
            }
            ImmutableList.Builder links = ImmutableList.builder();
            for (Map linkMap : (List)scalingPolicyMap.get("links")) {
                Link link = Link.builder().href(URI.create((String)linkMap.get("href"))).relation(Link.Relation.fromValue((String)((String)linkMap.get("rel")))).build();
                links.add((Object)link);
            }
            Double d = (Double)scalingPolicyMap.get(targetType.toString());
            ScalingPolicy scalingPolicyResponse = new ScalingPolicy((String)scalingPolicyMap.get("name"), (CreateScalingPolicy.ScalingPolicyType)((Object)CreateScalingPolicy.ScalingPolicyType.getByValue((String)scalingPolicyMap.get("type")).get()), ((Double)scalingPolicyMap.get("cooldown")).intValue(), DoubleMath.isMathematicalInteger((double)d) ? Integer.toString(d.intValue()) : Double.toString(d), targetType, (Map)scalingPolicyMap.get("args"), (List<Link>)ImmutableList.copyOf((Collection)links.build()), (String)scalingPolicyMap.get("id"));
            scalingPoliciesList.add((Object)scalingPolicyResponse);
        }
        ImmutableList.Builder links = ImmutableList.builder();
        for (Map linkMap : (List)group.get("links")) {
            Link link = Link.builder().href(URI.create((String)linkMap.get("href"))).relation(Link.Relation.fromValue((String)((String)linkMap.get("rel")))).build();
            links.add((Object)link);
        }
        String groupId = (String)group.get("id");
        return Group.builder().id(groupId).scalingPolicy((List<ScalingPolicy>)scalingPoliciesList.build()).groupConfiguration(groupConfiguration).launchConfiguration(launchConfiguration).links((List<Link>)links.build()).build();
    }
}

