/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.domain.ScalingPolicy;

public class ParseScalingPoliciesResponse
implements Function<HttpResponse, FluentIterable<ScalingPolicy>> {
    private final ParseJson<Map<String, List<Map<String, Object>>>> json;

    @Inject
    ParseScalingPoliciesResponse(ParseJson<Map<String, List<Map<String, Object>>>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public FluentIterable<ScalingPolicy> apply(HttpResponse from) {
        Map singleMap = (Map)this.json.apply(from);
        List result = (List)singleMap.get("policies");
        ImmutableList.Builder scalingPoliciesList = ImmutableList.builder();
        for (Map scalingPolicyMap : result) {
            CreateScalingPolicy.ScalingPolicyTargetType targetType = null;
            for (String key : scalingPolicyMap.keySet()) {
                if (!CreateScalingPolicy.ScalingPolicyTargetType.getByValue(key).isPresent()) continue;
                targetType = (CreateScalingPolicy.ScalingPolicyTargetType)((Object)CreateScalingPolicy.ScalingPolicyTargetType.getByValue(key).get());
                break;
            }
            ImmutableList.Builder links = ImmutableList.builder();
            for (Map linkMap : (List)scalingPolicyMap.get("links")) {
                Link link = Link.builder().href(URI.create((String)linkMap.get("href"))).relation(Link.Relation.fromValue((String)((String)linkMap.get("rel")))).build();
                links.add((Object)link);
            }
            Double d = (Double)scalingPolicyMap.get(targetType.toString());
            ScalingPolicy scalingPolicyResponse = new ScalingPolicy((String)scalingPolicyMap.get("name"), (CreateScalingPolicy.ScalingPolicyType)((Object)CreateScalingPolicy.ScalingPolicyType.getByValue((String)scalingPolicyMap.get("type")).get()), ((Double)scalingPolicyMap.get("cooldown")).intValue(), DoubleMath.isMathematicalInteger((double)d) ? Integer.toString(d.intValue()) : Double.toString(d), targetType, (Map)scalingPolicyMap.get("args"), (List<Link>)ImmutableList.copyOf((Collection)links.build()), (String)scalingPolicyMap.get("id"));
            scalingPoliciesList.add((Object)scalingPolicyResponse);
        }
        return FluentIterable.from((Iterable)scalingPoliciesList.build());
    }
}

