/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.autoscale.v1.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jclouds.rackspace.autoscale.v1.domain.CreateScalingPolicy;
import org.jclouds.rackspace.autoscale.v1.domain.LaunchConfiguration;

public class ParseHelper {
    public static ImmutableMap<String, Object> buildLaunchConfigurationRequestMap(Map<String, Object> postParams) {
        LaunchConfiguration launchConfigurationRequest = (LaunchConfiguration)postParams.get("launchConfiguration");
        ImmutableMap.Builder launchConfigurationMapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder argsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder serverBuilder = ImmutableMap.builder();
        ImmutableList.Builder networksBuilder = ImmutableList.builder();
        for (String networkId : launchConfigurationRequest.getNetworks()) {
            HashMap network = Maps.newHashMap();
            network.put("uuid", networkId);
            networksBuilder.add((Object)network);
        }
        serverBuilder.put((Object)"name", (Object)launchConfigurationRequest.getServerName());
        serverBuilder.put((Object)"imageRef", (Object)launchConfigurationRequest.getServerImageRef());
        serverBuilder.put((Object)"flavorRef", (Object)launchConfigurationRequest.getServerFlavorRef());
        serverBuilder.put((Object)"OS-DCF:diskConfig", (Object)launchConfigurationRequest.getServerDiskConfig());
        serverBuilder.put((Object)"metadata", launchConfigurationRequest.getServerMetadata());
        serverBuilder.put((Object)"personality", launchConfigurationRequest.getPersonalities());
        serverBuilder.put((Object)"networks", (Object)networksBuilder.build());
        argsBuilder.put((Object)"loadBalancers", launchConfigurationRequest.getLoadBalancers());
        argsBuilder.put((Object)"server", (Object)serverBuilder.build());
        launchConfigurationMapBuilder.put((Object)"type", (Object)launchConfigurationRequest.getType().toString());
        launchConfigurationMapBuilder.put((Object)"args", (Object)argsBuilder.build());
        return launchConfigurationMapBuilder.build();
    }

    public static ImmutableList<Map<String, Object>> buildScalingPoliciesRequestList(Map<String, Object> postParams) {
        List scalingPoliciesRequest = (List)postParams.get("scalingPolicies");
        ImmutableList.Builder scalingPoliciesListBuilder = ImmutableList.builder();
        for (CreateScalingPolicy scalingPolicy : scalingPoliciesRequest) {
            scalingPoliciesListBuilder.add(ParseHelper.buildScalingPolicyMap(scalingPolicy));
        }
        return scalingPoliciesListBuilder.build();
    }

    public static ImmutableMap<String, Object> buildScalingPolicyMap(CreateScalingPolicy scalingPolicy) {
        ImmutableMap.Builder scalingPolicyMapBuilder = ImmutableMap.builder();
        scalingPolicyMapBuilder.put((Object)"cooldown", (Object)scalingPolicy.getCooldown());
        scalingPolicyMapBuilder.put((Object)"type", (Object)scalingPolicy.getType().toString());
        scalingPolicyMapBuilder.put((Object)"name", (Object)scalingPolicy.getName());
        String targetString = scalingPolicy.getTarget();
        Integer targetInt = Ints.tryParse((String)targetString);
        if (targetInt != null) {
            scalingPolicyMapBuilder.put((Object)scalingPolicy.getTargetType().toString(), (Object)targetInt);
        } else {
            Float targetFloat = Floats.tryParse((String)targetString);
            if (targetFloat != null) {
                scalingPolicyMapBuilder.put((Object)scalingPolicy.getTargetType().toString(), (Object)targetFloat);
            } else {
                scalingPolicyMapBuilder.put((Object)scalingPolicy.getTargetType().toString(), (Object)targetString);
            }
        }
        if (scalingPolicy.getSchedulingType() != null && scalingPolicy.getType().equals((Object)CreateScalingPolicy.ScalingPolicyType.SCHEDULE)) {
            scalingPolicyMapBuilder.put((Object)"args", (Object)ImmutableMap.of((Object)scalingPolicy.getSchedulingType().toString(), (Object)scalingPolicy.getSchedulingString()));
        }
        return scalingPolicyMapBuilder.build();
    }
}

