/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cdn.uk;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.poppy.v1.PoppyApiMetadata;
import org.jclouds.openstack.poppy.v1.config.PoppyHttpApiModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationApiModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationModule;

@AutoService(value=ProviderMetadata.class)
public class CDNUKProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CDNUKProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public CDNUKProviderMetadata() {
        this(new Builder());
    }

    protected CDNUKProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.keystone.credential-type", "RAX-KSKEY:apiKeyCredentials");
        properties.setProperty("jclouds.keystone.service-type", "rax:cdn");
        properties.setProperty("jclouds.regions", "LON");
        properties.setProperty("jclouds.region.LON.iso3166-codes", "GB-SLG");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("rackspace-cdn-uk").name("Rackspace CDN UK").apiMetadata((ApiMetadata)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)new PoppyApiMetadata().toBuilder().identityName("${userName}")).credentialName("${apiKey}")).defaultEndpoint("https://lon.identity.api.rackspacecloud.com/v2.0/")).documentation(URI.create("http://docs.rackspace.com/cdn/api/v1.0/cdn-devguide/content/index.html"))).endpointName("Rackspace Cloud Identity service URL ending in /v2.0/")).version("1")).defaultModules((Set)ImmutableSet.builder().add(CloudIdentityAuthenticationApiModule.class).add(CloudIdentityAuthenticationModule.class).add(KeystoneAuthenticationModule.ProviderModule.class).add(PoppyHttpApiModule.class).build())).build()).console(URI.create("https://mycloud.rackspace.co.uk")).linkedServices(new String[]{"rackspace-autoscale-uk", "rackspace-cloudblockstorage-uk", "rackspace-clouddatabases-uk", "rackspace-clouddns-uk", "rackspace-cloudidentity", "rackspace-cloudloadbalancers-uk", "rackspace-cloudqueues-uk", "rackspace-cloudservers-uk", "rackspace-cloudnetworks-uk"}).iso3166Codes(new String[]{"GB-SLG"}).defaultProperties(CDNUKProviderMetadata.defaultProperties());
        }

        public CDNUKProviderMetadata build() {
            return new CDNUKProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

