/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cdn.us;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.poppy.v1.PoppyApiMetadata;
import org.jclouds.openstack.poppy.v1.config.PoppyHttpApiModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationApiModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationModule;

@AutoService(value=ProviderMetadata.class)
public class CDNUSProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CDNUSProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public CDNUSProviderMetadata() {
        this(new Builder());
    }

    protected CDNUSProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.keystone.credential-type", "RAX-KSKEY:apiKeyCredentials");
        properties.setProperty("jclouds.keystone.service-type", "rax:cdn");
        properties.setProperty("jclouds.regions", "ORD,DFW,IAD,SYD,HKG");
        properties.setProperty("jclouds.region.ORD.iso3166-codes", "US-IL");
        properties.setProperty("jclouds.region.DFW.iso3166-codes", "US-TX");
        properties.setProperty("jclouds.region.IAD.iso3166-codes", "US-VA");
        properties.setProperty("jclouds.region.SYD.iso3166-codes", "AU-NSW");
        properties.setProperty("jclouds.region.HKG.iso3166-codes", "HK");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("rackspace-cdn-us").name("Rackspace CDN US").apiMetadata((ApiMetadata)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)((PoppyApiMetadata.Builder)new PoppyApiMetadata().toBuilder().identityName("${userName}")).credentialName("${apiKey}")).defaultEndpoint("https://identity.api.rackspacecloud.com/v2.0/")).documentation(URI.create("http://docs.rackspace.com/cdn/api/v1.0/cdn-devguide/content/index.html"))).endpointName("Rackspace Cloud Identity service URL ending in /v2.0/")).version("1")).defaultModules((Set)ImmutableSet.builder().add(CloudIdentityAuthenticationApiModule.class).add(CloudIdentityAuthenticationModule.class).add(KeystoneAuthenticationModule.ProviderModule.class).add(PoppyHttpApiModule.class).build())).build()).homepage(URI.create("http://www.rackspace.com/cloud/cdn-content-delivery-network")).console(URI.create("https://mycloud.rackspace.com")).linkedServices(new String[]{"rackspace-autoscale-us", "rackspace-cloudblockstorage-us", "rackspace-clouddatabases-us", "rackspace-clouddns-us", "rackspace-cloudidentity", "rackspace-cloudloadbalancers-us", "rackspace-cloudqueues-us"}).iso3166Codes(new String[]{"US-IL", "US-TX", "US-VA", "AU-NSW", "HK"}).defaultProperties(CDNUSProviderMetadata.defaultProperties());
        }

        public CDNUSProviderMetadata build() {
            return new CDNUSProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

