/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.gogrid.domain.BillingToken;
import org.jclouds.gogrid.domain.Customer;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.javax.annotation.Nullable;

public class ServerImage
implements Comparable<ServerImage> {
    private final long id;
    private final String name;
    private final String friendlyName;
    private final String description;
    private final Option os;
    private final Option architecture;
    private final ServerImageType type;
    private final ServerImageState state;
    private final double price;
    private final String location;
    private final boolean isActive;
    private final boolean isPublic;
    private final Date createdTime;
    private final Date updatedTime;
    private final Set<BillingToken> billingTokens;
    private final Customer owner;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerImage(this);
    }

    @ConstructorProperties(value={"id", "name", "friendlyName", "description", "os", "architecture", "type", "state", "price", "location", "isActive", "isPublic", "createdTime", "updatedTime", "billingtokens", "owner"})
    protected ServerImage(long id, String name, String friendlyName, @Nullable String description, Option os, @Nullable Option architecture, ServerImageType type, ServerImageState state, double price, String location, boolean isActive, boolean isPublic, @Nullable Date createdTime, @Nullable Date updatedTime, Set<BillingToken> billingTokens, Customer owner) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.friendlyName = (String)Preconditions.checkNotNull((Object)friendlyName, (Object)"friendlyName");
        this.description = Strings.nullToEmpty((String)description);
        this.os = (Option)Preconditions.checkNotNull((Object)os, (Object)"os");
        this.architecture = architecture;
        this.type = (ServerImageType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.state = (ServerImageState)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.price = price;
        this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.isActive = isActive;
        this.isPublic = isPublic;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        this.billingTokens = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(billingTokens, (Object)"billingTokens")));
        this.owner = (Customer)Preconditions.checkNotNull((Object)owner, (Object)"owner");
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public Option getOs() {
        return this.os;
    }

    @Nullable
    public Option getArchitecture() {
        return this.architecture;
    }

    public ServerImageType getType() {
        return this.type;
    }

    public ServerImageState getState() {
        return this.state;
    }

    public double getPrice() {
        return this.price;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @Nullable
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public Set<BillingToken> getBillingTokens() {
        return this.billingTokens;
    }

    public Customer getOwner() {
        return this.owner;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.friendlyName, this.description, this.os, this.architecture, this.type, this.state, this.price, this.location, this.isActive, this.isPublic, this.createdTime, this.updatedTime, this.billingTokens, this.owner});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerImage that = (ServerImage)ServerImage.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.friendlyName, (Object)that.friendlyName) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.os, (Object)that.os) && Objects.equal((Object)this.architecture, (Object)that.architecture) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.price, (Object)that.price) && Objects.equal((Object)this.location, (Object)that.location) && Objects.equal((Object)this.isActive, (Object)that.isActive) && Objects.equal((Object)this.isPublic, (Object)that.isPublic) && Objects.equal((Object)this.createdTime, (Object)that.createdTime) && Objects.equal((Object)this.updatedTime, (Object)that.updatedTime) && Objects.equal(this.billingTokens, that.billingTokens) && Objects.equal((Object)this.owner, (Object)that.owner);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("friendlyName", (Object)this.friendlyName).add("description", (Object)this.description).add("os", (Object)this.os).add("architecture", (Object)this.architecture).add("type", (Object)this.type).add("state", (Object)this.state).add("price", this.price).add("location", (Object)this.location).add("isActive", this.isActive).add("isPublic", this.isPublic).add("createdTime", (Object)this.createdTime).add("updatedTime", (Object)this.updatedTime).add("billingTokens", this.billingTokens).add("owner", (Object)this.owner);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(ServerImage that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return Longs.compare((long)this.id, (long)that.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected String name;
        protected String friendlyName;
        protected String description;
        protected Option os;
        protected Option architecture;
        protected ServerImageType type;
        protected ServerImageState state;
        protected double price;
        protected String location;
        protected boolean isActive;
        protected boolean isPublic;
        protected Date createdTime;
        protected Date updatedTime;
        protected Set<BillingToken> billingTokens = ImmutableSet.of();
        protected Customer owner;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T os(Option os) {
            this.os = os;
            return this.self();
        }

        public T architecture(Option architecture) {
            this.architecture = architecture;
            return this.self();
        }

        public T type(ServerImageType type) {
            this.type = type;
            return this.self();
        }

        public T state(ServerImageState state) {
            this.state = state;
            return this.self();
        }

        public T price(double price) {
            this.price = price;
            return this.self();
        }

        public T location(String location) {
            this.location = location;
            return this.self();
        }

        public T isActive(boolean isActive) {
            this.isActive = isActive;
            return this.self();
        }

        public T isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this.self();
        }

        public T createdTime(Date createdTime) {
            this.createdTime = createdTime;
            return this.self();
        }

        public T updatedTime(Date updatedTime) {
            this.updatedTime = updatedTime;
            return this.self();
        }

        public T billingTokens(Set<BillingToken> billingTokens) {
            this.billingTokens = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(billingTokens, (Object)"billingTokens")));
            return this.self();
        }

        public T billingTokens(BillingToken ... in) {
            return this.billingTokens((Set<BillingToken>)ImmutableSet.copyOf((Object[])in));
        }

        public T owner(Customer owner) {
            this.owner = owner;
            return this.self();
        }

        public ServerImage build() {
            return new ServerImage(this.id, this.name, this.friendlyName, this.description, this.os, this.architecture, this.type, this.state, this.price, this.location, this.isActive, this.isPublic, this.createdTime, this.updatedTime, this.billingTokens, this.owner);
        }

        public T fromServerImage(ServerImage in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).friendlyName(in.getFriendlyName())).description(in.getDescription())).os(in.getOs())).architecture(in.getArchitecture())).type(in.getType())).state(in.getState())).price(in.getPrice())).location(in.getLocation())).isActive(in.isActive())).isPublic(in.isPublic())).createdTime(in.getCreatedTime())).updatedTime(in.getUpdatedTime())).billingTokens(in.getBillingTokens())).owner(in.getOwner());
        }
    }
}

