/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jclouds.softlayer.domain.ContainerVirtualGuestConfigurationOption;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;

public class ContainerVirtualGuestConfiguration {
    public static final String SWAP_DEVICE = "1";
    private final Set<ContainerVirtualGuestConfigurationOption> blockDevices;
    private final Set<ContainerVirtualGuestConfigurationOption> datacenters;
    private final Set<ContainerVirtualGuestConfigurationOption> memory;
    private final Set<ContainerVirtualGuestConfigurationOption> networkComponents;
    private final Set<ContainerVirtualGuestConfigurationOption> operatingSystems;
    private final Set<ContainerVirtualGuestConfigurationOption> processors;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ContainerVirtualGuestConfiguration.builder().fromContainerVirtualGuestConfiguration(this);
    }

    @ConstructorProperties(value={"blockDevices", "datacenters", "memory", "networkComponents", "operatingSystems", "processors"})
    public ContainerVirtualGuestConfiguration(Set<ContainerVirtualGuestConfigurationOption> blockDevices, Set<ContainerVirtualGuestConfigurationOption> datacenters, Set<ContainerVirtualGuestConfigurationOption> memory, Set<ContainerVirtualGuestConfigurationOption> networkComponents, Set<ContainerVirtualGuestConfigurationOption> operatingSystems, Set<ContainerVirtualGuestConfigurationOption> processors) {
        this.blockDevices = (Set)Preconditions.checkNotNull(blockDevices, (Object)"blockDevices");
        this.datacenters = (Set)Preconditions.checkNotNull(datacenters, (Object)"datacenters");
        this.memory = (Set)Preconditions.checkNotNull(memory, (Object)"memory");
        this.networkComponents = (Set)Preconditions.checkNotNull(networkComponents, (Object)"networkComponents");
        this.operatingSystems = (Set)Preconditions.checkNotNull(operatingSystems, (Object)"operatingSystems");
        this.processors = (Set)Preconditions.checkNotNull(processors, (Object)"processors");
    }

    public Set<ContainerVirtualGuestConfigurationOption> getBlockDevices() {
        return this.blockDevices;
    }

    public Set<ContainerVirtualGuestConfigurationOption> getDatacenters() {
        return this.datacenters;
    }

    public Set<ContainerVirtualGuestConfigurationOption> getMemory() {
        return this.memory;
    }

    public Set<ContainerVirtualGuestConfigurationOption> getNetworkComponents() {
        return this.networkComponents;
    }

    public Set<ContainerVirtualGuestConfigurationOption> getOperatingSystems() {
        return this.operatingSystems;
    }

    public Set<ContainerVirtualGuestConfigurationOption> getProcessors() {
        return this.processors;
    }

    public Set<Integer> getCpusOfProcessors() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.processors, (Function)new Function<ContainerVirtualGuestConfigurationOption, Integer>(){

            public Integer apply(ContainerVirtualGuestConfigurationOption input) {
                return input.getTemplate().getStartCpus();
            }
        }));
    }

    public Set<Integer> getMemories() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.memory, (Function)new Function<ContainerVirtualGuestConfigurationOption, Integer>(){

            public Integer apply(ContainerVirtualGuestConfigurationOption input) {
                return input.getTemplate().getMaxMemory();
            }
        }));
    }

    public Set<Datacenter> getVirtualGuestDatacenters() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.datacenters, (Function)new Function<ContainerVirtualGuestConfigurationOption, Datacenter>(){

            public Datacenter apply(ContainerVirtualGuestConfigurationOption input) {
                return input.getTemplate().getDatacenter();
            }
        }));
    }

    public Set<OperatingSystem> getVirtualGuestOperatingSystems() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.operatingSystems, (Function)new Function<ContainerVirtualGuestConfigurationOption, OperatingSystem>(){

            public OperatingSystem apply(ContainerVirtualGuestConfigurationOption input) {
                return OperatingSystem.builder().id(input.getTemplate().getOperatingSystemReferenceCode()).operatingSystemReferenceCode(input.getTemplate().getOperatingSystemReferenceCode()).build();
            }
        }));
    }

    public Set<VirtualGuestBlockDevice> getVirtualGuestBlockDevices() {
        HashSet virtualGuestBlockDevices = Sets.newHashSet();
        for (final ContainerVirtualGuestConfigurationOption configurationOption : this.blockDevices) {
            virtualGuestBlockDevices.addAll(FluentIterable.from(configurationOption.getTemplate().getVirtualGuestBlockDevices()).filter((Predicate)new Predicate<VirtualGuestBlockDevice>(){

                public boolean apply(VirtualGuestBlockDevice input) {
                    return !input.getDevice().equals(ContainerVirtualGuestConfiguration.SWAP_DEVICE);
                }
            }).transform((Function)new Function<VirtualGuestBlockDevice, VirtualGuestBlockDevice>(){

                public VirtualGuestBlockDevice apply(VirtualGuestBlockDevice input) {
                    return input.toBuilder().guest(configurationOption.getTemplate()).build();
                }
            }).toSet());
        }
        return virtualGuestBlockDevices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerVirtualGuestConfiguration that = (ContainerVirtualGuestConfiguration)o;
        return Objects.equal(this.blockDevices, that.blockDevices) && Objects.equal(this.datacenters, that.datacenters) && Objects.equal(this.memory, that.memory) && Objects.equal(this.networkComponents, that.networkComponents) && Objects.equal(this.operatingSystems, that.operatingSystems) && Objects.equal(this.processors, that.processors);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.blockDevices, this.datacenters, this.memory, this.networkComponents, this.operatingSystems, this.processors});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("blockDevices", this.blockDevices).add("datacenters", this.datacenters).add("memory", this.memory).add("networkComponents", this.networkComponents).add("operatingSystems", this.operatingSystems).add("processors", this.processors).toString();
    }

    public static class Builder {
        protected Set<ContainerVirtualGuestConfigurationOption> blockDevices;
        protected Set<ContainerVirtualGuestConfigurationOption> datacenters;
        protected Set<ContainerVirtualGuestConfigurationOption> memory;
        protected Set<ContainerVirtualGuestConfigurationOption> networkComponents;
        protected Set<ContainerVirtualGuestConfigurationOption> operatingSystems;
        protected Set<ContainerVirtualGuestConfigurationOption> processors;

        public Builder blockDevices(Set<ContainerVirtualGuestConfigurationOption> blockDevices) {
            this.blockDevices = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(blockDevices, (Object)"blockDevices")));
            return this;
        }

        public Builder blockDevices(ContainerVirtualGuestConfigurationOption ... in) {
            return this.blockDevices((Set<ContainerVirtualGuestConfigurationOption>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder datacenters(Set<ContainerVirtualGuestConfigurationOption> datacenters) {
            this.datacenters = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(datacenters, (Object)"datacenters")));
            return this;
        }

        public Builder datacenters(ContainerVirtualGuestConfigurationOption ... in) {
            return this.datacenters((Set<ContainerVirtualGuestConfigurationOption>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder memory(Set<ContainerVirtualGuestConfigurationOption> memory) {
            this.memory = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(memory, (Object)"memory")));
            return this;
        }

        public Builder memory(ContainerVirtualGuestConfigurationOption ... in) {
            return this.memory((Set<ContainerVirtualGuestConfigurationOption>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder networkComponents(Set<ContainerVirtualGuestConfigurationOption> networkComponents) {
            this.networkComponents = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(networkComponents, (Object)"networkComponents")));
            return this;
        }

        public Builder networkComponents(ContainerVirtualGuestConfigurationOption ... in) {
            return this.networkComponents((Set<ContainerVirtualGuestConfigurationOption>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder operatingSystems(Set<ContainerVirtualGuestConfigurationOption> operatingSystems) {
            this.operatingSystems = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(operatingSystems, (Object)"operatingSystems")));
            return this;
        }

        public Builder operatingSystems(ContainerVirtualGuestConfigurationOption ... in) {
            return this.operatingSystems((Set<ContainerVirtualGuestConfigurationOption>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder processors(Set<ContainerVirtualGuestConfigurationOption> processors) {
            this.processors = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(processors, (Object)"processors")));
            return this;
        }

        public Builder processors(ContainerVirtualGuestConfigurationOption ... in) {
            return this.processors((Set<ContainerVirtualGuestConfigurationOption>)ImmutableSet.copyOf((Object[])in));
        }

        public ContainerVirtualGuestConfiguration build() {
            return new ContainerVirtualGuestConfiguration(this.blockDevices, this.datacenters, this.memory, this.networkComponents, this.operatingSystems, this.processors);
        }

        public Builder fromContainerVirtualGuestConfiguration(ContainerVirtualGuestConfiguration in) {
            return this.blockDevices(in.getBlockDevices()).datacenters(in.getDatacenters()).memory(in.getMemory()).networkComponents(in.getNetworkComponents()).operatingSystems(in.getOperatingSystems()).processors(in.getProcessors());
        }
    }
}

