/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.Assert;
import org.junit.Test;

public class NodeApiVersionsTest {
    @Test
    public void testUnsupportedVersionsToString() {
        NodeApiVersions versions = new NodeApiVersions(Collections.emptyList());
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix).append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED");
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testVersionsToString() {
        ArrayList<ApiVersionsResponse.ApiVersion> versionList = new ArrayList<ApiVersionsResponse.ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey == ApiKeys.CONTROLLED_SHUTDOWN_KEY) {
                versionList.add(new ApiVersionsResponse.ApiVersion(apiKey.id, 0, 0));
                continue;
            }
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                versionList.add(new ApiVersionsResponse.ApiVersion(apiKey.id, 10000, 10001));
                continue;
            }
            versionList.add(new ApiVersionsResponse.ApiVersion(apiKey.id, ProtoUtils.oldestVersion((int)apiKey.id), ProtoUtils.latestVersion((int)apiKey.id)));
        }
        NodeApiVersions versions = new NodeApiVersions(versionList);
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix);
            if (apiKey == ApiKeys.CONTROLLED_SHUTDOWN_KEY) {
                bld.append("ControlledShutdown(7): 0 [unusable: node too old]");
            } else if (apiKey == ApiKeys.DELETE_TOPICS) {
                bld.append("DeleteTopics(20): 10000 to 10001 [unusable: node too new]");
            } else {
                bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
                if (ProtoUtils.oldestVersion((int)apiKey.id) == ProtoUtils.latestVersion((int)apiKey.id)) {
                    bld.append(ProtoUtils.oldestVersion((int)apiKey.id));
                } else {
                    bld.append(ProtoUtils.oldestVersion((int)apiKey.id)).append(" to ").append(ProtoUtils.latestVersion((int)apiKey.id));
                }
                bld.append(" [usable: ").append(ProtoUtils.latestVersion((int)apiKey.id)).append("]");
            }
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testUsableVersionCalculation() {
        ArrayList<ApiVersionsResponse.ApiVersion> versionList = new ArrayList<ApiVersionsResponse.ApiVersion>();
        versionList.add(new ApiVersionsResponse.ApiVersion(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id, 0, 0));
        versionList.add(new ApiVersionsResponse.ApiVersion(ApiKeys.FETCH.id, 1, 2));
        NodeApiVersions versions = new NodeApiVersions(versionList);
        try {
            versions.usableVersion(ApiKeys.CONTROLLED_SHUTDOWN_KEY);
            Assert.fail((String)"expected UnsupportedVersionException");
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)versions.usableVersion(ApiKeys.FETCH));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testUsableVersionCalculationNoKnownVersions() {
        ArrayList versionList = new ArrayList();
        NodeApiVersions versions = new NodeApiVersions(versionList);
        versions.usableVersion(ApiKeys.FETCH);
    }

    @Test
    public void testUsableVersionLatestVersions() {
        LinkedList<ApiVersionsResponse.ApiVersion> versionList = new LinkedList<ApiVersionsResponse.ApiVersion>();
        for (ApiVersionsResponse.ApiVersion apiVersion : ApiVersionsResponse.API_VERSIONS_RESPONSE.apiVersions()) {
            versionList.add(apiVersion);
        }
        versionList.add(new ApiVersionsResponse.ApiVersion(100, 0, 1));
        NodeApiVersions versions = new NodeApiVersions(versionList);
        for (ApiKeys apiKey : ApiKeys.values()) {
            Assert.assertEquals((long)ProtoUtils.latestVersion((int)apiKey.id), (long)versions.usableVersion(apiKey));
        }
    }
}

