/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MemoryRecordsBuilderTest {
    private final CompressionType compressionType;
    private final int bufferOffset;

    public MemoryRecordsBuilderTest(int bufferOffset, CompressionType compressionType) {
        this.bufferOffset = bufferOffset;
        this.compressionType = compressionType;
    }

    @Test
    public void testCompressionRateV0() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        Record[] records = new Record[]{Record.create((byte)0, (long)0L, (byte[])"a".getBytes(), (byte[])"1".getBytes()), Record.create((byte)0, (long)1L, (byte[])"b".getBytes(), (byte[])"2".getBytes()), Record.create((byte)0, (long)2L, (byte[])"c".getBytes(), (byte[])"3".getBytes())};
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 0, this.compressionType, TimestampType.CREATE_TIME, 0L, 0L, buffer.capacity());
        int uncompressedSize = 0;
        for (Record record : records) {
            uncompressedSize += record.sizeInBytes() + 12;
            builder.append(record);
        }
        MemoryRecords built = builder.build();
        if (this.compressionType == CompressionType.NONE) {
            Assert.assertEquals((double)1.0, (double)builder.compressionRate(), (double)1.0E-5);
        } else {
            int compressedSize = built.sizeInBytes() - 12 - 14;
            double computedCompressionRate = (double)compressedSize / (double)uncompressedSize;
            Assert.assertEquals((double)computedCompressionRate, (double)builder.compressionRate(), (double)1.0E-5);
        }
    }

    @Test
    public void testCompressionRateV1() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        Record[] records = new Record[]{Record.create((byte)1, (long)0L, (byte[])"a".getBytes(), (byte[])"1".getBytes()), Record.create((byte)1, (long)1L, (byte[])"b".getBytes(), (byte[])"2".getBytes()), Record.create((byte)1, (long)2L, (byte[])"c".getBytes(), (byte[])"3".getBytes())};
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, 0L, buffer.capacity());
        int uncompressedSize = 0;
        for (Record record : records) {
            uncompressedSize += record.sizeInBytes() + 12;
            builder.append(record);
        }
        MemoryRecords built = builder.build();
        if (this.compressionType == CompressionType.NONE) {
            Assert.assertEquals((double)1.0, (double)builder.compressionRate(), (double)1.0E-5);
        } else {
            int compressedSize = built.sizeInBytes() - 12 - 22;
            double computedCompressionRate = (double)compressedSize / (double)uncompressedSize;
            Assert.assertEquals((double)computedCompressionRate, (double)builder.compressionRate(), (double)1.0E-5);
        }
    }

    @Test
    public void buildUsingLogAppendTime() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.LOG_APPEND_TIME, 0L, logAppendTime, buffer.capacity());
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.append(0L, "b".getBytes(), "2".getBytes());
        builder.append(0L, "c".getBytes(), "3".getBytes());
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        Assert.assertEquals((long)logAppendTime, (long)info.maxTimestamp);
        Assert.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        for (Record record : records.records()) {
            Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)record.timestampType());
            Assert.assertEquals((long)logAppendTime, (long)record.timestamp());
        }
    }

    @Test
    public void convertUsingLogAppendTime() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.LOG_APPEND_TIME, 0L, logAppendTime, buffer.capacity());
        builder.convertAndAppend(Record.create((byte)0, (long)0L, (byte[])"a".getBytes(), (byte[])"1".getBytes()));
        builder.convertAndAppend(Record.create((byte)0, (long)0L, (byte[])"b".getBytes(), (byte[])"2".getBytes()));
        builder.convertAndAppend(Record.create((byte)0, (long)0L, (byte[])"c".getBytes(), (byte[])"3".getBytes()));
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        Assert.assertEquals((long)logAppendTime, (long)info.maxTimestamp);
        Assert.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        for (Record record : records.records()) {
            Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)record.timestampType());
            Assert.assertEquals((long)logAppendTime, (long)record.timestamp());
        }
    }

    @Test
    public void buildUsingCreateTime() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, logAppendTime, buffer.capacity());
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.append(2L, "b".getBytes(), "2".getBytes());
        builder.append(1L, "c".getBytes(), "3".getBytes());
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        Assert.assertEquals((long)2L, (long)info.maxTimestamp);
        if (this.compressionType == CompressionType.NONE) {
            Assert.assertEquals((long)1L, (long)info.shallowOffsetOfMaxTimestamp);
        } else {
            Assert.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        }
        int i = 0;
        long[] expectedTimestamps = new long[]{0L, 2L, 1L};
        for (Record record : records.records()) {
            Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)record.timestampType());
            Assert.assertEquals((long)expectedTimestamps[i++], (long)record.timestamp());
        }
    }

    @Test
    public void testSmallWriteLimit() {
        byte[] key = "foo".getBytes();
        byte[] value = "bar".getBytes();
        int writeLimit = 0;
        ByteBuffer buffer = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, -1L, writeLimit);
        Assert.assertFalse((boolean)builder.isFull());
        Assert.assertTrue((boolean)builder.hasRoomFor(key, value));
        builder.append(0L, key, value);
        Assert.assertTrue((boolean)builder.isFull());
        Assert.assertFalse((boolean)builder.hasRoomFor(key, value));
        MemoryRecords memRecords = builder.build();
        List records = TestUtils.toList(memRecords.records());
        Assert.assertEquals((long)1L, (long)records.size());
        Record record = (Record)records.get(0);
        Assert.assertEquals((Object)ByteBuffer.wrap(key), (Object)record.key());
        Assert.assertEquals((Object)ByteBuffer.wrap(value), (Object)record.value());
    }

    @Test
    public void writePastLimit() {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, logAppendTime, buffer.capacity());
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.append(1L, "b".getBytes(), "2".getBytes());
        Assert.assertFalse((boolean)builder.hasRoomFor("c".getBytes(), "3".getBytes()));
        builder.append(2L, "c".getBytes(), "3".getBytes());
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        Assert.assertEquals((long)2L, (long)info.maxTimestamp);
        Assert.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        long i = 0L;
        for (Record record : records.records()) {
            Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)record.timestampType());
            Assert.assertEquals((long)i++, (long)record.timestamp());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendAtInvalidOffset() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, logAppendTime, buffer.capacity());
        builder.appendWithOffset(0L, System.currentTimeMillis(), "a".getBytes(), null);
        builder.appendWithOffset(0L, System.currentTimeMillis(), "b".getBytes(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendWithInvalidMagic() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, logAppendTime, buffer.capacity());
        builder.append(Record.create((byte)0, (long)0L, (byte[])"a".getBytes(), null));
    }

    @Test
    public void convertUsingCreateTime() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(this.bufferOffset);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 1, this.compressionType, TimestampType.CREATE_TIME, 0L, logAppendTime, buffer.capacity());
        builder.convertAndAppend(Record.create((byte)0, (long)0L, (byte[])"a".getBytes(), (byte[])"1".getBytes()));
        builder.convertAndAppend(Record.create((byte)0, (long)0L, (byte[])"b".getBytes(), (byte[])"2".getBytes()));
        builder.convertAndAppend(Record.create((byte)0, (long)0L, (byte[])"c".getBytes(), (byte[])"3".getBytes()));
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        Assert.assertEquals((long)-1L, (long)info.maxTimestamp);
        Assert.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        for (Record record : records.records()) {
            Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)record.timestampType());
            Assert.assertEquals((long)-1L, (long)record.timestamp());
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (int bufferOffset : Arrays.asList(0, 15)) {
            for (CompressionType compressionType : CompressionType.values()) {
                values.add(new Object[]{bufferOffset, compressionType});
            }
        }
        return values;
    }
}

