/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.locks.Condition;
import kafka.api.RequestOrResponse;
import kafka.api.StopReplicaResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tmb\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Au\u00111aU3u!\t\u0011SE\u0004\u0002\nG%\u0011AEC\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%\u0015!A\u0011\u0006\u0001B\u0001B\u0003%1$\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5rs\u0006\r\t\u0003-\u0001AQa\u0001\u0016A\u0002UAqA\u0007\u0016\u0011\u0002\u0003\u00071\u0004C\u0004*UA\u0005\t\u0019A\u000e\t\u000fI\u0002!\u0019!C\u0001g\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003Q\u0002\"AF\u001b\n\u0005Y\u0012!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"1\u0001\b\u0001Q\u0001\nQ\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!9!\b\u0001b\u0001\n\u0003Y\u0014!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002yA\u0011a#P\u0005\u0003}\t\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0003\u0004A\u0001\u0001\u0006I\u0001P\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!9!\t\u0001b\u0001\n\u0003\u0019\u0015a\u0005:fa2L7-Y*uCR,W*Y2iS:,W#\u0001#\u0011\u0005Y)\u0015B\u0001$\u0003\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002BqA\u0013\u0001A\u0002\u0013\u00051*A\tu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012,\u0012\u0001\u0014\t\u0004\u001bB\u000bS\"\u0001(\u000b\u0005=k\u0012aB7vi\u0006\u0014G.Z\u0005\u0003A9CqA\u0015\u0001A\u0002\u0013\u00051+A\u000bu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012|F%Z9\u0015\u0005Q;\u0006CA\u0005V\u0013\t1&B\u0001\u0003V]&$\bb\u0002-R\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0004B\u0002.\u0001A\u0003&A*\u0001\nu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u0004\u0003b\u0002/\u0001\u0001\u0004%\taS\u0001\u001ci>\u0004\u0018nY:J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\t\u000fy\u0003\u0001\u0019!C\u0001?\u0006yBo\u001c9jGNLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:|F%Z9\u0015\u0005Q\u0003\u0007b\u0002-^\u0003\u0003\u0005\r\u0001\u0014\u0005\u0007E\u0002\u0001\u000b\u0015\u0002'\u00029Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8oA!9A\r\u0001b\u0001\n\u0003)\u0017\u0001\u00053fY\u0016$X\rV8qS\u000e\u001c8i\u001c8e+\u00051\u0007CA4q\u001b\u0005A'BA5k\u0003\u0015awnY6t\u0015\tYG.\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001c8\u0002\tU$\u0018\u000e\u001c\u0006\u0002_\u0006!!.\u0019<b\u0013\t\t\bNA\u0005D_:$\u0017\u000e^5p]\"11\u000f\u0001Q\u0001\n\u0019\f\u0011\u0003Z3mKR,Gk\u001c9jGN\u001cuN\u001c3!\u0011\u001d)\b\u00011A\u0005\u0002Y\fq\u0003Z3mKR,Gk\u001c9jGN#\u0018\r^3DQ\u0006tw-\u001a3\u0016\u0003]\u0004\"!\u0003=\n\u0005eT!a\u0002\"p_2,\u0017M\u001c\u0005\bw\u0002\u0001\r\u0011\"\u0001}\u0003m!W\r\\3uKR{\u0007/[2Ti\u0006$Xm\u00115b]\u001e,Gm\u0018\u0013fcR\u0011A+ \u0005\b1j\f\t\u00111\u0001x\u0011\u0019y\b\u0001)Q\u0005o\u0006AB-\u001a7fi\u0016$v\u000e]5d'R\fG/Z\"iC:<W\r\u001a\u0011\t\u0013\u0005\r\u0001\u00011A\u0005\u0002\u0005\u0015\u0011A\u00053fY\u0016$X\rV8qS\u000e\u001cH\u000b\u001b:fC\u0012,\"!a\u0002\u0011\t\u0005%\u00111B\u0007\u0002\u0001\u00191\u0011Q\u0002\u0001\u0001\u0003\u001f\u0011!\u0003R3mKR,Gk\u001c9jGN$\u0006N]3bIN!\u00111BA\t!\ry\u00111C\u0005\u0004\u0003+\u0001\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012DqaKA\u0006\t\u0003\tI\u0002\u0006\u0002\u0002\b!Q\u0011QDA\u0006\u0005\u0004%\t!a\b\u0002\u0011i\\7\t\\5f]R,\"!!\t\u0011\t\u0005\r\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u0005A!p[2mS\u0016tGO\u0003\u0003\u0002,\u00055\u0012AB%1\u0013R,7M\u0003\u0002\u00020\u0005\u0019qN]4\n\t\u0005M\u0012Q\u0005\u0002\t5.\u001cE.[3oi\"I\u0011qGA\u0006A\u0003%\u0011\u0011E\u0001\nu.\u001cE.[3oi\u0002B\u0001\"a\u000f\u0002\f\u0011\u0005\u0013QH\u0001\u0007I><vN]6\u0015\u0003QC\u0011\"!\u0011\u0001\u0001\u0004%\t!a\u0011\u0002-\u0011,G.\u001a;f)>\u0004\u0018nY:UQJ,\u0017\rZ0%KF$2\u0001VA#\u0011%A\u0016qHA\u0001\u0002\u0004\t9\u0001\u0003\u0005\u0002J\u0001\u0001\u000b\u0015BA\u0004\u0003M!W\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193!\u0011\u001d\ti\u0005\u0001C\u0001\u0003{\tQa\u001d;beRDq!!\u0015\u0001\t\u0003\ti$\u0001\u0005tQV$Hm\\<o\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n\u0001$\u001a8rk\u0016,X\rV8qS\u000e\u001chi\u001c:EK2,G/[8o)\r!\u0016\u0011\f\u0005\b\u00037\n\u0019\u00061\u0001\u001c\u0003\u0019!x\u000e]5dg\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\r!\u00161\r\u0005\n\u00037\ni\u0006%AA\u0002mAq!a\u001a\u0001\t\u0003\tI'A\ngC&d'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002U\u0003WB\u0001\"!\u001c\u0002f\u0001\u0007\u0011qN\u0001\te\u0016\u0004H.[2bgB!AdHA9!\r1\u00121O\u0005\u0004\u0003k\u0012!a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007bBA=\u0001\u0011\u0005\u00111P\u0001\u001f[\u0006\u00148\u000eV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$2\u0001VA?\u0011\u001d\tY&a\u001eA\u0002mAq!!!\u0001\t\u0003\t\u0019)\u0001\u000fjgR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007]\f)\tC\u0004\u0002\b\u0006}\u0004\u0019A\u0011\u0002\u000bQ|\u0007/[2\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\u0006I\u0012n\u001d+pa&\u001cG)\u001a7fi&|g.\u00138Qe><'/Z:t)\r9\u0018q\u0012\u0005\b\u0003\u000f\u000bI\t1\u0001\"\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u000b!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$2a^AL\u0011\u001d\t9)!%A\u0002\u0005Bq!a'\u0001\t\u0013\ti$\u0001\u0010bo\u0006LG\u000fV8qS\u000e$U\r\\3uS>tgj\u001c;jM&\u001c\u0017\r^5p]\"9\u0011q\u0014\u0001\u0005\n\u0005u\u0012!\u0007:fgVlW\rV8qS\u000e$U\r\\3uS>tG\u000b\u001b:fC\u0012Dq!a)\u0001\t\u0013\t)+A\fd_6\u0004H.\u001a;f%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019A+a*\t\u0011\u00055\u0014\u0011\u0015a\u0001\u0003_Bq!a+\u0001\t\u0013\ti+\u0001\u000ejgR{\u0007/[2FY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002x\u0003_Cq!a\"\u0002*\u0002\u0007\u0011\u0005C\u0004\u00024\u0002!I!!.\u000235\f'o\u001b+pa&\u001cgi\u001c:EK2,G/[8o%\u0016$(/\u001f\u000b\u0004)\u0006]\u0006bBAD\u0003c\u0003\r!\t\u0005\b\u0003w\u0003A\u0011BA_\u0003M\u0019w.\u001c9mKR,G)\u001a7fi\u0016$v\u000e]5d)\r!\u0016q\u0018\u0005\b\u0003\u000f\u000bI\f1\u0001\"\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000b\fqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u0004)\u0006\u001d\u0007bBA.\u0003\u0003\u0004\ra\u0007\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003Q\u0019H/\u0019:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019A+a4\t\u0011\u0005E\u0017\u0011\u001aa\u0001\u0003_\nAD]3qY&\u001c\u0017m\u001d$peR{\u0007/[2t)>\u0014U\rR3mKR,G\rC\u0004\u0002V\u0002!I!a6\u0002'=t\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u0007Q\u000bI\u000e\u0003\u0005\u0002\\\u0006M\u0007\u0019AAo\u0003U\u0001\u0018M\u001d;ji&|gn\u001d+p\u0005\u0016$U\r\\3uK\u0012\u0004B\u0001H\u0010\u0002`B!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002f\u0012\taaY8n[>t\u0017\u0002BAu\u0003G\u0014\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\ti\u000f\u0001C\u0005\u0003_\fa\u0004Z3mKR,Gk\u001c9jGN#x\u000e\u001d*fa2L7-Y\"bY2\u0014\u0017mY6\u0015\u000bQ\u000b\tP!\u0001\t\u0011\u0005M\u00181\u001ea\u0001\u0003k\fac\u001d;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016|%M\u001b\t\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111 \u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0000\u0006e(!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\"A!1AAv\u0001\u0004\u0011)!A\u0005sKBd\u0017nY1JIB\u0019\u0011Ba\u0002\n\u0007\t%!BA\u0002J]RD\u0011B!\u0004\u0001#\u0003%\tAa\u0004\u0002CI,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE!fA\u000e\u0003\u0014-\u0012!Q\u0003\t\u0005\u0005/\u0011\t#\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0003 )\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019C!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0005\u0003(\t\t\t\u0011#\u0001\u0003*\u0005!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u00042A\u0006B\u0016\r!\t!!!A\t\u0002\t52c\u0001B\u0016\u0011!91Fa\u000b\u0005\u0002\tEBC\u0001B\u0015\u0011)\u0011)Da\u000b\u0012\u0002\u0013\u0005!qB\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\te\"1FI\u0001\n\u0003\u0011y!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private scala.collection.mutable.Set<String> topicsToBeDeleted;
    private scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private boolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Set<String> $lessinit$greater$default$3() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> $lessinit$greater$default$2() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public void topicsToBeDeleted_$eq(scala.collection.mutable.Set<String> x$1) {
        this.topicsToBeDeleted = x$1;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void topicsIneligibleForDeletion_$eq(scala.collection.mutable.Set<String> x$1) {
        this.topicsIneligibleForDeletion = x$1;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public boolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public void deleteTopicStateChanged_$eq(boolean x$1) {
        this.deleteTopicStateChanged = x$1;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread x$1) {
        this.deleteTopicsThread = x$1;
    }

    public void start() {
        this.deleteTopicsThread_$eq(new DeleteTopicsThread());
        this.deleteTopicStateChanged_$eq(true);
        this.deleteTopicsThread().start();
    }

    public void shutdown() {
        this.deleteTopicsThread().shutdown();
        this.topicsToBeDeleted().clear();
        this.topicsIneligibleForDeletion().clear();
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        this.topicsToBeDeleted().$plus$plus$eq(topics);
        this.resumeTopicDeletionThread();
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted());
        if (topicsToResumeDeletion.size() > 0) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (replicasThatFailedToDelete.size() > 0) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
        this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
        if (newTopicsToHaltDeletion.size() > 0) {
            this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                }
                {
                    this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                }
            });
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return this.topicsIneligibleForDeletion().contains((Object)topic);
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic);
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic);
    }

    public void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        while (true) {
            if (this.deleteTopicStateChanged()) {
                this.deleteTopicStateChanged_$eq(false);
                return;
            }
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Waiting for signal to start or continue topic deletion";
                }
            });
            this.deleteTopicsCond().await();
        }
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged_$eq(true);
        this.deleteTopicsCond().signal();
    }

    public void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicConfigPath(topic));
        this.controllerContext().zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq());
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return ((TopicAndPartition)p._1()).topic();
            }
        });
        topics.foreach((Function1)new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion((Set<TopicAndPartition>)((TraversableOnce)((TraversableLike)this.partitionReplicaAssignmentByTopic$1.apply((Object)topic)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x$2) {
                        return (TopicAndPartition)x$2._1();
                    }
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$3) {
                return x$3.topic();
            }
        }).foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(Tuple2<String, Set<PartitionAndReplica>> x0$1) {
                Tuple2<String, Set<PartitionAndReplica>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String topic = (String)tuple2._1();
                    Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;

                        public final boolean apply(PartitionAndReplica p) {
                            return p.topic().equals(this.topic$1);
                        }
                        {
                            this.topic$1 = topic$1;
                        }
                    });
                    Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                    Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                    Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                    this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry){
                        public static final long serialVersionUID = 0L;
                        private final Set replicasForDeletionRetry$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                        }
                        {
                            this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<RequestOrResponse, Object, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                        public final void apply(RequestOrResponse stopReplicaResponseObj, int replicaId) {
                            this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(stopReplicaResponseObj, replicaId);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }).build());
                    if (deadReplicasForTopic.size() > 0) {
                        this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(RequestOrResponse stopReplicaResponseObj, int replicaId) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)new Serializable(this, stopReplicaResponse){
            public static final long serialVersionUID = 0L;
            private final StopReplicaResponse stopReplicaResponse$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Delete topic callback invoked for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stopReplicaResponse$1}));
            }
            {
                this.stopReplicaResponse$1 = stopReplicaResponse$1;
            }
        });
        scala.collection.immutable.Set partitionsInError = stopReplicaResponse.errorCode() != ErrorMapping$.MODULE$.NoError() ? stopReplicaResponse.responseMap().keySet() : ((TraversableOnce)((TraversableLike)stopReplicaResponse.responseMap().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Object> p) {
                return BoxesRunTime.unboxToShort((Object)p._2()) != ErrorMapping$.MODULE$.NoError();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Object> x$4) {
                return (TopicAndPartition)x$4._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set replicasInError = (scala.collection.immutable.Set)partitionsInError.map((Function1)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final int replicaId$1;

            public final PartitionAndReplica apply(TopicAndPartition p) {
                return new PartitionAndReplica(p.topic(), p.partition(), this.replicaId$1);
            }
            {
                this.replicaId$1 = replicaId$1;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new Serializable(this, replicaId, stopReplicaResponse, partitionsInError, replicasInError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            public final int replicaId$1;
            private final StopReplicaResponse stopReplicaResponse$1;
            private final scala.collection.immutable.Set partitionsInError$1;
            private final scala.collection.immutable.Set replicasInError$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.failReplicaDeletion((Set<PartitionAndReplica>)this.replicasInError$1);
                if (this.replicasInError$1.size() != this.stopReplicaResponse$1.responseMap().size()) {
                    scala.collection.immutable.Set deletedReplicas = (scala.collection.immutable.Set)this.stopReplicaResponse$1.responseMap().keySet().$minus$minus((GenTraversableOnce)this.partitionsInError$1);
                    this.$outer.kafka$controller$TopicDeletionManager$$completeReplicaDeletion((Set<PartitionAndReplica>)((Set)deletedReplicas.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1 $outer;

                        public final PartitionAndReplica apply(TopicAndPartition p) {
                            return new PartitionAndReplica(p.topic(), p.partition(), this.$outer.replicaId$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
                this.stopReplicaResponse$1 = stopReplicaResponse$1;
                this.partitionsInError$1 = partitionsInError$1;
                this.replicasInError$1 = replicasInError$1;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.controllerContext().controllerLock().newCondition();
        this.deleteTopicStateChanged = false;
        this.deleteTopicsThread = null;
    }

    public class DeleteTopicsThread
    extends ShutdownableThread {
        private final ZkClient zkClient;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        @Override
        public void doWork() {
            Utils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicsThread $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
                    Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                    if (topicsQueuedForDeletion.size() > 0) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                            public static final long serialVersionUID = 0L;
                            private final Set topicsQueuedForDeletion$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                            }
                            {
                                this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                            }
                        });
                    }
                    topicsQueuedForDeletion.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DeleteTopicsThread$$anonfun$doWork$1 $outer;

                        public final void apply(String topic) {
                            if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$2;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = topic$2;
                                    }
                                });
                            } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                                Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                                Set replicaIds = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(PartitionAndReplica x$5) {
                                        return x$5.replica();
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                Set partitions = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final TopicAndPartition apply(PartitionAndReplica r) {
                                        return new TopicAndPartition(r.topic(), r.partition());
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic, replicaIds, partitions){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$2;
                                    private final Set replicaIds$1;
                                    private final Set partitions$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = topic$2;
                                        this.replicaIds$1 = replicaIds$1;
                                        this.partitions$1 = partitions$1;
                                    }
                                });
                            } else {
                                Set<PartitionAndReplica> replicasInTopicDeletionFailedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic, replicasInTopicDeletionFailedState){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$2;
                                    private final Set replicasInTopicDeletionFailedState$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.replicasInTopicDeletionFailedState$1.mkString(",")}));
                                    }
                                    {
                                        this.topic$2 = topic$2;
                                        this.replicasInTopicDeletionFailedState$1 = replicasInTopicDeletionFailedState$1;
                                    }
                                });
                            }
                            if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$2;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = topic$2;
                                    }
                                });
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                            } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$2;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                                    }
                                    {
                                        this.topic$2 = topic$2;
                                    }
                                });
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ DeleteTopicsThread kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return TopicDeletionManager.this;
        }

        public DeleteTopicsThread() {
            if (TopicDeletionManager.this == null) {
                throw new NullPointerException();
            }
            super("delete-topics-thread", ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
            this.zkClient = TopicDeletionManager.this.controllerContext().zkClient();
        }
    }
}

