/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupExecutor;
import kafka.admin.DescribeConsumerGroupTest$;
import kafka.consumer.OldConsumer;
import kafka.consumer.Whitelist;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.errors.GroupCoordinatorNotAvailableException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004R3tGJL'-Z\"p]N,X.\u001a:He>,\b\u000fV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003/Q\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013\u0005q$A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011)H/\u001b7\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0015\u0001A\u0003%\u0001%\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!91\u0006\u0001b\u0001\n\u0003a\u0013!\u0002;pa&\u001cW#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0013\u0001\u00027b]\u001eL!AM\u0018\u0003\rM#(/\u001b8h\u0011\u0019!\u0004\u0001)A\u0005[\u00051Ao\u001c9jG\u0002BqA\u000e\u0001C\u0002\u0013\u0005q'A\u0006u_BL7MR5mi\u0016\u0014X#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\"\u0011\u0001C2p]N,X.\u001a:\n\u0005uR$!C,iSR,G.[:u\u0011\u0019y\u0004\u0001)A\u0005q\u0005aAo\u001c9jG\u001aKG\u000e^3sA!9\u0011\t\u0001b\u0001\n\u0003a\u0013!B4s_V\u0004\bBB\"\u0001A\u0003%Q&\u0001\u0004he>,\b\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001 \u0003\u0015\u0001(o\u001c9t\u0011\u00199\u0005\u0001)A\u0005A\u00051\u0001O]8qg\u0002BQ!\u0013\u0001\u0005B)\u000bqbZ3oKJ\fG/Z\"p]\u001aLwm\u001d\u000b\u0002\u0017B\u0019AJV-\u000f\u00055\u001bfB\u0001(R\u001b\u0005y%B\u0001)\u0007\u0003\u0019a$o\\8u}%\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U+\u00069\u0001/Y2lC\u001e,'\"\u0001*\n\u0005]C&aA*fc*\u0011A+\u0016\t\u00035vk\u0011a\u0017\u0006\u00039\u0012\taa]3sm\u0016\u0014\u0018B\u00010\\\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b\u0001\u0004A\u0011I1\u0002\u000bM,G/\u00169\u0015\u0003\t\u0004\"a\u00193\u000e\u0003UK!!Z+\u0003\tUs\u0017\u000e\u001e\u0015\u0003?\u001e\u0004\"\u0001\u001b6\u000e\u0003%T!a\u0003\b\n\u0005-L'A\u0002\"fM>\u0014X\rC\u0003n\u0001\u0011\u0005\u0011-\u0001\u000fuKN$H)Z:de&\u0014WMT8o\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9)\u00051|\u0007C\u00015q\u0013\t\t\u0018N\u0001\u0003UKN$\b\"B:\u0001\t\u0003\t\u0017!\u0007;fgR$Um]2sS\n,W\t_5ti&twm\u0012:pkBD#A]8\t\u000bY\u0004A\u0011A1\u0002MQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Fq&\u001cH/\u001b8h\u000fJ|W\u000f],ji\"tu.T3nE\u0016\u00148\u000f\u000b\u0002v_\")\u0011\u0010\u0001C\u0001C\u0006iC/Z:u\t\u0016\u001c8M]5cK\u000e{gn];nKJ\u001cx+\u001b;i\u001d>\f5o]5h]\u0016$\u0007+\u0019:uSRLwN\\:)\u0005a|\u0007\"\u0002?\u0001\t\u0003\t\u0017a\u000b;fgR$Um]2sS\n,gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f],ji\"tUm^\"p]N,X.\u001a:)\u0005m|\u0007\"B@\u0001\t\u0003\t\u0017\u0001\u000b;fgR$Um]2sS\n,W\t_5ti&twm\u0012:pkB<\u0016\u000e\u001e5OK^\u001cuN\\:v[\u0016\u0014\bF\u0001@p\u0011\u0019\t)\u0001\u0001C\u0001C\u0006)D/Z:u\t\u0016\u001c8M]5cK\u0016C\u0018n\u001d;j]\u001e<%o\\;q/&$\bNT8NK6\u0014WM]:XSRDg*Z<D_:\u001cX/\\3sQ\r\t\u0019a\u001c\u0005\u0007\u0003\u0017\u0001A\u0011A1\u0002yQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3D_:\u001cX/\\3sg^KG\u000f\u001b(p\u0003N\u001c\u0018n\u001a8fIB\u000b'\u000f^5uS>t7oV5uQ:+woQ8ogVlWM\u001d\u0015\u0004\u0003\u0013y\u0007BBA\t\u0001\u0011\u0005\u0011-\u0001$uKN$H)Z:de&\u0014WmV5uQ6+H\u000e^5QCJ$\u0018\u000e^5p]R{\u0007/[2B]\u0012lU\u000f\u001c;ja2,7i\u001c8tk6,'o],ji\"tUm^\"p]N,X.\u001a:)\u0007\u0005=q\u000e")
public class DescribeConsumerGroupTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final Properties overridingProps;
    private final String topic;
    private final Whitelist topicFilter;
    private final String group;
    private final Properties props;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        DescribeConsumerGroupTest describeConsumerGroupTest = this;
        synchronized (describeConsumerGroupTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic() {
        return this.topic;
    }

    public Whitelist topicFilter() {
        return this.topicFilter;
    }

    public String group() {
        return this.group;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.props().setProperty("group.id", this.group());
    }

    @Test
    public void testDescribeNonExistingGroup() {
        this.props().setProperty("zookeeper.connect", this.zkConnect());
        OldConsumer consumerMock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", "missing.group"}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        EasyMock.replay((Object[])new Object[]{consumerMock});
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Option)this.consumerGroupCommand$1.describeGroup()._2()).isEmpty();
            }
            {
                this.consumerGroupCommand$1 = consumerGroupCommand$1;
            }
        }, "Expected no rows in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
        consumerMock.stop();
    }

    @Test
    public void testDescribeExistingGroup() {
        this.props().setProperty("zookeeper.connect", this.zkConnect());
        OldConsumer consumerMock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", this.group()}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        EasyMock.replay((Object[])new Object[]{consumerMock});
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Tuple2 tuple2 = this.consumerGroupCommand$2.describeGroup();
                if (tuple2 != null) {
                    Option assignments = (Option)tuple2._2();
                    Option option = assignments;
                    Option assignments2 = option;
                    return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeExistingGroup$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$2) {
                            String string = x$2.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeExistingGroup$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$3) {
                            String string = x$3.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).head()).consumerId().exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$4) {
                            String string = x$4.trim();
                            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                            return string != null ? !string.equals(string2) : string2 != null;
                        }
                    });
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$2 = consumerGroupCommand$2;
            }
        }, "Expected rows and a consumer id column in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
        consumerMock.stop();
    }

    @Test
    public void testDescribeExistingGroupWithNoMembers() {
        this.props().setProperty("zookeeper.connect", this.zkConnect());
        OldConsumer consumerMock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", this.group()}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        EasyMock.replay((Object[])new Object[]{consumerMock});
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Tuple2 tuple2 = this.consumerGroupCommand$3.describeGroup();
                if (tuple2 != null) {
                    Option assignments = (Option)tuple2._2();
                    Option option = assignments;
                    Option assignments2 = option;
                    return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembers$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$5) {
                            String string = x$5.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembers$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$6) {
                            String string = x$6.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).head()).consumerId().exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$7) {
                            String string = x$7.trim();
                            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                            return string != null ? !string.equals(string2) : string2 != null;
                        }
                    });
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$3 = consumerGroupCommand$3;
            }
        }, "Expected rows and a consumer id column in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerMock.stop();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Tuple2 tuple2 = this.consumerGroupCommand$3.describeGroup();
                if (tuple2 != null) {
                    Option assignments = (Option)tuple2._2();
                    Option option = assignments;
                    Option assignments2 = option;
                    return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembers$2 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$8) {
                            String string = x$8.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembers$2 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$9) {
                            String string = x$9.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).head()).consumerId().exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$10) {
                            String string = x$10.trim();
                            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                    });
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$3 = consumerGroupCommand$3;
            }
        }, "Expected no active member in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
    }

    @Test
    public void testDescribeConsumersWithNoAssignedPartitions() {
        this.props().setProperty("zookeeper.connect", this.zkConnect());
        OldConsumer consumer1Mock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        OldConsumer consumer2Mock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{this.topicFilter(), this.props()}).createMock();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", this.group()}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        EasyMock.replay((Object[])new Object[]{consumer1Mock});
        EasyMock.replay((Object[])new Object[]{consumer2Mock});
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Tuple2 tuple2 = this.consumerGroupCommand$4.describeGroup();
                if (tuple2 != null) {
                    Option assignments = (Option)tuple2._2();
                    Option option = assignments;
                    Option assignments2 = option;
                    return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeConsumersWithNoAssignedPartitions$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$11) {
                            String string = x$11.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }) == 2 && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeConsumersWithNoAssignedPartitions$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x) {
                            String string = x.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }) == 1 && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeConsumersWithNoAssignedPartitions$1 $outer;

                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x) {
                            String string = x.group();
                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                            return !(string != null ? !string.equals(string2) : string2 != null) && !x.partition().isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }) == 1;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$4 = consumerGroupCommand$4;
            }
        }, "Expected rows for consumers with no assigned partitions in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
        consumer1Mock.stop();
        consumer2Mock.stop();
    }

    @Test
    public void testDescribeNonExistingGroupWithNewConsumer() {
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(this.brokerList(), 1, this.group(), this.topic());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Unable to fully structure code
             */
            public boolean apply$mcZ$sp() {
                block8: {
                    block7: {
                        try {
                            block9: {
                                var7_1 = this.consumerGroupCommand$5.describeGroup();
                                if (var7_1 == null) break block9;
                                state = (Option)var7_1._1();
                                assignments = (Option)var7_1._2();
                                var6_5 = var10_4 = new Tuple2((Object)state, (Object)assignments);
                                state = (Option)var6_5._1();
                                assignments = (Option)var6_5._2();
                                v0 = state;
                                var13_8 = new Some((Object)"Dead");
                                if (v0 != null ? v0.equals(var13_8) == false : var13_8 != null) ** GOTO lbl-1000
                                v1 = assignments;
                                var14_9 = new Some((Object)Nil$.MODULE$);
                                if (!(v1 != null ? v1.equals(var14_9) == false : var14_9 != null)) {
                                    v2 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                }
                                Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)v2));
                                v3 = state;
                                var15_10 = new Some((Object)"Dead");
                                if (v3 != null ? v3.equals(var15_10) == false : var15_10 != null) ** GOTO lbl-1000
                                v4 = assignments;
                                var16_11 = new Some((Object)Nil$.MODULE$);
                                if (!(v4 != null ? v4.equals(var16_11) == false : var16_11 != null)) {
                                    v5 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v5 = false;
                                }
                                break block7;
                            }
                            throw new MatchError((Object)var7_1);
                        }
                        catch (Throwable var1_12) {
                            var2_13 = var1_12;
                            var3_14 = var2_13 instanceof GroupCoordinatorNotAvailableException != false ? true : var2_13 instanceof IllegalArgumentException != false;
                            if (!var3_14) break block8;
                            v5 = var4_15 = false;
                        }
                    }
                    return v5;
                }
                if (var2_13 != null) {
                    var5_16 = var2_13;
                    var5_16.printStackTrace();
                    throw var5_16;
                }
                throw var1_12;
            }
            {
                this.consumerGroupCommand$5 = consumerGroupCommand$5;
            }
        }, "Expected the state to be 'Dead' with no members in the group.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
    }

    @Test
    public void testDescribeExistingGroupWithNewConsumer() {
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(this.brokerList(), 1, this.group(), this.topic());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                Throwable throwable;
                Throwable throwable22;
                block7: {
                    boolean bl;
                    try {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = this.consumerGroupCommand$6.describeGroup();
                        if (tuple22 == null) throw new MatchError((Object)tuple22);
                        Option state = (Option)tuple22._1();
                        Option assignments = (Option)tuple22._2();
                        Tuple2 tuple23 = tuple2 = new Tuple2((Object)state, (Object)assignments);
                        Option state2 = (Option)tuple23._1();
                        Option assignments2 = (Option)tuple23._2();
                        Option option = state2;
                        Some some = new Some((Object)"Stable");
                        if (option == null) {
                            if (some != null) {
                                return false;
                            }
                        } else if (!option.equals(some)) return false;
                        if (!assignments2.isDefined()) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$14) {
                                String string = x$14.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 1) return false;
                        if (!((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$15) {
                                String string = x$15.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).head()).consumerId().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$16) {
                                String string = x$16.trim();
                                String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                        })) return false;
                        if (!((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$17) {
                                String string = x$17.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).head()).clientId().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$18) {
                                String string = x$18.trim();
                                String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                        })) return false;
                        if (!((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$19) {
                                String string = x$19.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).head()).host().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$20) {
                                String string = x$20.trim();
                                String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                        })) return false;
                        return true;
                    }
                    catch (Throwable throwable22) {
                        boolean bl2;
                        throwable = throwable22;
                        if (throwable instanceof GroupCoordinatorNotAvailableException) {
                            return false;
                        }
                        if (throwable instanceof IllegalArgumentException) {
                            return false;
                        }
                        boolean bl3 = false;
                        if (!bl3) break block7;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                if (throwable == null) throw throwable22;
                Throwable throwable3 = throwable;
                throw throwable3;
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$6 = consumerGroupCommand$6;
            }
        }, "Expected a 'Stable' group status, rows and valid values for consumer id / client id / host columns in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
    }

    @Test
    public void testDescribeExistingGroupWithNoMembersWithNewConsumer() {
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(this.brokerList(), 1, this.group(), this.topic());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Throwable throwable;
                Throwable throwable22;
                block5: {
                    boolean bl;
                    block4: {
                        try {
                            Tuple2 tuple2 = this.consumerGroupCommand$7.describeGroup();
                            if (tuple2 != null) {
                                Option state;
                                Option option;
                                Option state2;
                                Option option2 = state2 = (option = (state = (Option)tuple2._1()));
                                Some some = new Some((Object)"Stable");
                                bl = !(option2 != null ? !option2.equals(some) : some != null);
                                break block4;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        catch (Throwable throwable22) {
                            boolean bl2;
                            throwable = throwable22;
                            boolean bl3 = throwable instanceof GroupCoordinatorNotAvailableException ? true : throwable instanceof IllegalArgumentException;
                            if (!bl3) break block5;
                            bl = bl2 = false;
                        }
                    }
                    return bl;
                }
                if (throwable != null) {
                    Throwable throwable3 = throwable;
                    throw throwable3;
                }
                throw throwable22;
            }
            {
                this.consumerGroupCommand$7 = consumerGroupCommand$7;
            }
        }, "Expected the group to initially become stable.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                try {
                    Throwable throwable;
                    Throwable throwable22;
                    block10: {
                        boolean bl;
                        try {
                            Tuple2 tuple2 = this.consumerGroupCommand$7.describeGroup();
                            if (tuple2 != null) {
                                Tuple2 tuple22;
                                Option state = (Option)tuple2._1();
                                Option assignments = (Option)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)state, (Object)assignments);
                                Option state2 = (Option)tuple23._1();
                                Option assignments2 = (Option)tuple23._2();
                                Option option = state2;
                                Some some = new Some((Object)"Empty");
                                if (!(option != null ? !option.equals(some) : some != null)) {
                                    if (assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembersWithNewConsumer$2 $outer;

                                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$22) {
                                            String string = x$22.group();
                                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembersWithNewConsumer$2 $outer;

                                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$23) {
                                            String string = x$23.group();
                                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    })).head()).consumerId().exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$24) {
                                            String string = x$24.trim();
                                            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                    }) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembersWithNewConsumer$2 $outer;

                                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$25) {
                                            String string = x$25.group();
                                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    })).head()).clientId().exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$26) {
                                            String string = x$26.trim();
                                            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                    }) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testDescribeExistingGroupWithNoMembersWithNewConsumer$2 $outer;

                                        public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$27) {
                                            String string = x$27.group();
                                            String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    })).head()).host().exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$28) {
                                            String string = x$28.trim();
                                            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                    })) {
                                        bl = true;
                                    }
                                }
                                bl = false;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        catch (Throwable throwable22) {
                            boolean bl2;
                            throwable = throwable22;
                            boolean bl3 = throwable instanceof GroupCoordinatorNotAvailableException ? true : throwable instanceof IllegalArgumentException;
                            if (!bl3) break block10;
                            bl = bl2 = false;
                        }
                        return bl;
                    }
                    if (throwable != null) {
                        Throwable throwable3 = throwable;
                        throw throwable3;
                    }
                    throw throwable22;
                }
                finally {
                    this.consumerGroupCommand$7.close();
                }
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$7 = consumerGroupCommand$7;
            }
        }, "Expected no active member in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeConsumersWithNoAssignedPartitionsWithNewConsumer() {
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(this.brokerList(), 2, this.group(), this.topic());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                Throwable throwable;
                Throwable throwable22;
                block7: {
                    boolean bl;
                    try {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = this.consumerGroupCommand$8.describeGroup();
                        if (tuple22 == null) throw new MatchError((Object)tuple22);
                        Option state = (Option)tuple22._1();
                        Option assignments = (Option)tuple22._2();
                        Tuple2 tuple23 = tuple2 = new Tuple2((Object)state, (Object)assignments);
                        Option state2 = (Option)tuple23._1();
                        Option assignments2 = (Option)tuple23._2();
                        Option option = state2;
                        Some some = new Some((Object)"Stable");
                        if (option == null) {
                            if (some != null) {
                                return false;
                            }
                        } else if (!option.equals(some)) return false;
                        if (!assignments2.isDefined()) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeConsumersWithNoAssignedPartitionsWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$30) {
                                String string = x$30.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 2) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeConsumersWithNoAssignedPartitionsWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x) {
                                String string = x.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 1) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeConsumersWithNoAssignedPartitionsWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x) {
                                String string = x.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null) && !x.partition().isDefined();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 1) return false;
                        return true;
                    }
                    catch (Throwable throwable22) {
                        boolean bl2;
                        throwable = throwable22;
                        if (throwable instanceof GroupCoordinatorNotAvailableException) {
                            return false;
                        }
                        if (throwable instanceof IllegalArgumentException) {
                            return false;
                        }
                        boolean bl3 = false;
                        if (!bl3) break block7;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                if (throwable == null) throw throwable22;
                Throwable throwable3 = throwable;
                throw throwable3;
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$8 = consumerGroupCommand$8;
            }
        }, "Expected rows for consumers with no assigned partitions in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
    }

    @Test
    public void testDescribeWithMultiPartitionTopicAndMultipleConsumersWithNewConsumer() {
        String topic2 = "foo2";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(this.brokerList(), 2, this.group(), topic2);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerGroupCommand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeConsumerGroupTest $outer;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand$9;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                Throwable throwable;
                Throwable throwable22;
                block7: {
                    boolean bl;
                    try {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = this.consumerGroupCommand$9.describeGroup();
                        if (tuple22 == null) throw new MatchError((Object)tuple22);
                        Option state = (Option)tuple22._1();
                        Option assignments = (Option)tuple22._2();
                        Tuple2 tuple23 = tuple2 = new Tuple2((Object)state, (Object)assignments);
                        Option state2 = (Option)tuple23._1();
                        Option assignments2 = (Option)tuple23._2();
                        Option option = state2;
                        Some some = new Some((Object)"Stable");
                        if (option == null) {
                            if (some != null) {
                                return false;
                            }
                        } else if (!option.equals(some)) return false;
                        if (!assignments2.isDefined()) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumersWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x$32) {
                                String string = x$32.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 2) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumersWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x) {
                                String string = x.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 2) return false;
                        if (((TraversableOnce)assignments2.get()).count((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumersWithNewConsumer$1 $outer;

                            public final boolean apply(ConsumerGroupCommand.PartitionAssignmentState x) {
                                String string = x.group();
                                String string2 = this.$outer.kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer().group();
                                return !(string != null ? !string.equals(string2) : string2 != null) && !x.partition().isDefined();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) != 0) return false;
                        return true;
                    }
                    catch (Throwable throwable22) {
                        boolean bl2;
                        throwable = throwable22;
                        if (throwable instanceof GroupCoordinatorNotAvailableException) {
                            return false;
                        }
                        if (throwable instanceof IllegalArgumentException) {
                            return false;
                        }
                        boolean bl3 = false;
                        if (!bl3) break block7;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                if (throwable == null) throw throwable22;
                Throwable throwable3 = throwable;
                throw throwable3;
            }

            public /* synthetic */ DescribeConsumerGroupTest kafka$admin$DescribeConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroupCommand$9 = consumerGroupCommand$9;
            }
        }, "Expected two rows (one row per consumer) in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
    }

    public DescribeConsumerGroupTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.overridingProps = new Properties();
        this.topic = "foo";
        this.topicFilter = new Whitelist(this.topic());
        this.group = "test.group";
        this.props = new Properties();
    }
}

