/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import kafka.common.Topic$;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001\u001d\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003/Q\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013%q$\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,W#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000f\u0003\u0004(\u0001\u0001\u0006I\u0001I\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0003 \u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKNDaa\u000b\u0001!\u0002\u0013\u0001\u0013AF:feZ,'/T3tg\u0006<W-T1y\u0005f$Xm\u001d\u0011\t\u000f5\u0002!\u0019!C\u0005?\u0005i\"/\u001a9mS\u000e\fg)\u001a;dQ6\u000b\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000f\u0003\u00040\u0001\u0001\u0006I\u0001I\u0001\u001fe\u0016\u0004H.[2b\r\u0016$8\r['bqB\u000b'\u000f^5uS>t')\u001f;fg\u0002Bq!\r\u0001C\u0002\u0013%q$\u0001\u000fsKBd\u0017nY1GKR\u001c\u0007.T1y%\u0016\u001c\bo\u001c8tK\nKH/Z:\t\rM\u0002\u0001\u0015!\u0003!\u0003u\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D(+Z:q_:\u001cXMQ=uKN\u0004\u0003bB\u001b\u0001\u0005\u0004%\taH\u0001\u000b]Vl7+\u001a:wKJ\u001c\bBB\u001c\u0001A\u0003%\u0001%A\u0006ok6\u001cVM\u001d<feN\u0004\u0003bB\u001d\u0001\u0005\u0004%\tAO\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!Q\u000f^5m\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004E\u0001\u0001\u0006IaO\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002BQA\u0012\u0001\u0005\u0002\u001d\u000bqbZ3oKJ\fG/Z\"p]\u001aLwm\u001d\u000b\u0002\u0011B\u0019\u0011*\u0015+\u000f\u0005){eBA&O\u001b\u0005a%BA'\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002QE\u00059\u0001/Y2lC\u001e,\u0017B\u0001*T\u0005\r\u0019V-\u001d\u0006\u0003!\n\u0002\"!\u0016-\u000e\u0003YS!a\u0016\u0003\u0002\rM,'O^3s\u0013\tIfKA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bB.\u0001\u0001\u0004%I\u0001X\u0001\naJ|G-^2feF*\u0012!\u0018\t\u0005=\u001aD\u0007.D\u0001`\u0015\t\u0001\u0017-\u0001\u0005qe>$WoY3s\u0015\t\u00117-A\u0004dY&,g\u000e^:\u000b\u0005\u0015!'BA3\u000f\u0003\u0019\t\u0007/Y2iK&\u0011qm\u0018\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0007\u0005J7.\u0003\u0002kE\t)\u0011I\u001d:bsB\u0011\u0011\u0005\\\u0005\u0003[\n\u0012AAQ=uK\"9q\u000e\u0001a\u0001\n\u0013\u0001\u0018!\u00049s_\u0012,8-\u001a:2?\u0012*\u0017\u000f\u0006\u0002riB\u0011\u0011E]\u0005\u0003g\n\u0012A!\u00168ji\"9QO\\A\u0001\u0002\u0004i\u0016a\u0001=%c!1q\u000f\u0001Q!\nu\u000b!\u0002\u001d:pIV\u001cWM]\u0019!\u0011\u001dI\b\u00011A\u0005\nq\u000b\u0011\u0002\u001d:pIV\u001cWM\u001d\u001a\t\u000fm\u0004\u0001\u0019!C\u0005y\u0006i\u0001O]8ek\u000e,'OM0%KF$\"!]?\t\u000fUT\u0018\u0011!a\u0001;\"1q\u0010\u0001Q!\nu\u000b!\u0002\u001d:pIV\u001cWM\u001d\u001a!\u0011!\t\u0019\u0001\u0001a\u0001\n\u0013a\u0016!\u00039s_\u0012,8-\u001a:4\u0011%\t9\u0001\u0001a\u0001\n\u0013\tI!A\u0007qe>$WoY3sg}#S-\u001d\u000b\u0004c\u0006-\u0001\u0002C;\u0002\u0006\u0005\u0005\t\u0019A/\t\u000f\u0005=\u0001\u0001)Q\u0005;\u0006Q\u0001O]8ek\u000e,'o\r\u0011\t\u0011\u0005M\u0001\u00011A\u0005\nq\u000b\u0011\u0002\u001d:pIV\u001cWM\u001d\u001b\t\u0013\u0005]\u0001\u00011A\u0005\n\u0005e\u0011!\u00049s_\u0012,8-\u001a:5?\u0012*\u0017\u000fF\u0002r\u00037A\u0001\"^A\u000b\u0003\u0003\u0005\r!\u0018\u0005\b\u0003?\u0001\u0001\u0015)\u0003^\u0003)\u0001(o\u001c3vG\u0016\u0014H\u0007\t\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003K\ta\u0001^8qS\u000e\fTCAA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017\u007f\u0005!A.\u00198h\u0013\u0011\t\t$a\u000b\u0003\rM#(/\u001b8h\u0011!\t)\u0004\u0001Q\u0001\n\u0005\u001d\u0012a\u0002;pa&\u001c\u0017\u0007\t\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003K\ta\u0001^8qS\u000e\u0014\u0004\u0002CA\u001f\u0001\u0001\u0006I!a\n\u0002\u000fQ|\u0007/[23A!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0013!B:fiV\u0003H#A9)\t\u0005}\u0012q\t\t\u0005\u0003\u0013\ni%\u0004\u0002\u0002L)\u00111BD\u0005\u0005\u0003\u001f\nYE\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003'\u0002A\u0011IA\"\u0003!!X-\u0019:E_^t\u0007\u0006BA)\u0003/\u0002B!!\u0013\u0002Z%!\u00111LA&\u0005\u0015\te\r^3s\u0011\u001d\ty\u0006\u0001C\u0001\u0003\u0007\nQ\u0004^3tiR{w\u000eT1sO\u0016\u0014VmY8sI^KG\u000f[!dWj+'o\u001c\u0015\u0005\u0003;\n\u0019\u0007\u0005\u0003\u0002J\u0005\u0015\u0014\u0002BA4\u0003\u0017\u0012A\u0001V3ti\"9\u00111\u000e\u0001\u0005\u0002\u0005\r\u0013\u0001\b;fgR$vn\u001c'be\u001e,'+Z2pe\u0012<\u0016\u000e\u001e5BG.|e.\u001a\u0015\u0005\u0003S\n\u0019\u0007C\u0004\u0002r\u0001!I!a\u001d\u0002W\rDWmY6U_>d\u0015M]4f%\u0016\u001cwN\u001d3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2$2!]A;\u0011\u001d\t9(a\u001cA\u0002\u0001\nA\"\\1y\r\u0016$8\r[*ju\u0016Dq!a\u001f\u0001\t\u0003\t\u0019%A\u0017uKN$\b+\u0019:uSRLwN\u001c+p_2\u000b'oZ3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2DC!!\u001f\u0002d!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0013\u0001\f;fgR\u0014Vm\u001d9p]N,Gk\\8MCJ<WMR8s%\u0016\u0004H.[2bi&|gnV5uQ\u0006\u001b7.\u00117mQ\u0011\ty(a\u0019\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002D\u0005!B/Z:u\u001d>tW\t_5ti\u0016tG\u000fV8qS\u000eDC!!\"\u0002d!9\u0011Q\u0012\u0001\u0005\u0002\u0005\r\u0013a\u0005;fgR<&o\u001c8h\u0005J|7.\u001a:MSN$\b\u0006BAF\u0003GBq!a%\u0001\t\u0003\t\u0019%\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003#\u000b\u0019\u0007C\u0004\u0002\u001a\u0002!\t!a\u0011\u0002'Q,7\u000f^*f]\u0012\fe\r^3s\u00072|7/\u001a3)\t\u0005]\u00151\r\u0005\b\u0003?\u0003A\u0011AA\"\u0003u!Xm\u001d;DC:tw\u000e^*f]\u0012$v.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007\u0006BAO\u0003GBq!!*\u0001\t\u0003\t\u0019%A\u000buKN$hj\u001c;F]>,x\r\u001b*fa2L7-Y:)\t\u0005\r\u00161\r\u0005\b\u0003W\u0003A\u0011AA\"\u0003!\"Xm\u001d;O_R,en\\;hQJ+\u0007\u000f\\5dCN\fe\r^3s\u0005J|7.\u001a:TQV$Hm\\<oQ\u0011\tI+a\u0019")
public class ProducerFailureHandlingTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes;
    private final int replicaFetchMaxPartitionBytes;
    private final int replicaFetchMaxResponseBytes;
    private final int numServers;
    private final Properties overridingProps;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4;
    private final String topic1;
    private final String topic2;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerFailureHandlingTest producerFailureHandlingTest = this;
        synchronized (producerFailureHandlingTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer1;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer2;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer3;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer4;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        String x$2 = this.brokerList();
        int x$3 = 0;
        long x$4 = 30000L;
        long x$5 = 10000L;
        long x$6 = this.producerBufferSize();
        int x$7 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$8 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$9 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$10 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$11 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$12 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$13 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$14 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$api$ProducerFailureHandlingTest$$producer1_$eq(TestUtils$.MODULE$.createNewProducer(x$2, x$3, x$5, x$6, x$7, x$8, x$4, x$9, x$10, x$11, x$12, x$13, x$14));
        String x$15 = this.brokerList();
        int x$16 = 1;
        long x$17 = 30000L;
        long x$18 = 10000L;
        long x$19 = this.producerBufferSize();
        int x$20 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$21 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$22 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$23 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$24 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$25 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$26 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$27 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$api$ProducerFailureHandlingTest$$producer2_$eq(TestUtils$.MODULE$.createNewProducer(x$15, x$16, x$18, x$19, x$20, x$21, x$17, x$22, x$23, x$24, x$25, x$26, x$27));
        String x$28 = this.brokerList();
        int x$29 = -1;
        long x$30 = 30000L;
        long x$31 = 10000L;
        long x$32 = this.producerBufferSize();
        int x$33 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$34 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$35 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$36 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$37 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$38 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$39 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$40 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$api$ProducerFailureHandlingTest$$producer3_$eq(TestUtils$.MODULE$.createNewProducer(x$28, x$29, x$31, x$32, x$33, x$34, x$30, x$35, x$36, x$37, x$38, x$39, x$40));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$api$ProducerFailureHandlingTest$$producer1() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer1().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer2() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer2().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer3() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer4() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer4().close();
        }
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assert.assertEquals((String)"Returned metadata should have offset -1", (long)((RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get()).offset(), (long)-1L);
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$1).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$1 = record$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)maxMessageSize)).toString());
        String topic10 = "topic10";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic10, this.servers().size(), this.numServers(), (Seq<KafkaServer>)this.servers(), topicConfig);
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)"key".getBytes(), (Object)new byte[maxMessageSize - 50]);
        RecordMetadata recordMetadata = (RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        Assert.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$2;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$2).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
    }

    @Test
    public void testWrongBrokerList() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$api$ProducerFailureHandlingTest$$producer4_$eq(TestUtils$.MODULE$.createNewProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6(), TestUtils$.MODULE$.createNewProducer$default$7(), TestUtils$.MODULE$.createNewProducer$default$8(), TestUtils$.MODULE$.createNewProducer$default$9(), TestUtils$.MODULE$.createNewProducer$default$10(), TestUtils$.MODULE$.createNewProducer$default$11(), TestUtils$.MODULE$.createNewProducer$default$12(), TestUtils$.MODULE$.createNewProducer$default$13()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$3;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer4().send(this.record$3).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$3 = record$3;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
    }

    @Test
    public void testInvalidPartition() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, higherRecord){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord higherRecord$1;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.higherRecord$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.higherRecord$1 = higherRecord$1;
            }
        }, ClassTag$.MODULE$.apply(KafkaException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
    }

    @Test
    public void testSendAfterClosed() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer2().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        ExecutionException thrown = (ExecutionException)this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(new ProducerRecord((String)Topic$.MODULE$.InternalTopics().head(), (Object)"test".getBytes(), (Object)"test".getBytes())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Unexpected exception while sending to an invalid topic ").append((Object)thrown.getCause()).toString(), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)(this.numServers() + 1))).toString());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 1, this.numServers(), (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        try {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotEnoughReplicasException) {
                return;
            }
            throw this.fail("Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 1, this.numServers(), (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        try {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotEnoughReplicasException || executionException.getCause() instanceof NotEnoughReplicasAfterAppendException || executionException.getCause() instanceof TimeoutException) {
                ((KafkaServer)this.servers().head()).startup();
                return;
            }
            throw this.fail(new StringBuilder().append((Object)"Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw ").append((Object)executionException.getCause()).toString(), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        }
    }

    public ProducerFailureHandlingTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.producerBufferSize = 30000;
        this.serverMessageMaxBytes = this.producerBufferSize() / 2;
        this.replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
        this.replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
        this.numServers = 2;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxPartitionBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxResponseBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

