/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import kafka.admin.AdminUtils$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.BrokerTopicStats$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0011\u0002\u0004\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011q\u0003\u0006\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!9A\u0005\u0001b\u0001\n\u0003)\u0013\u0001\u00038v[:{G-Z:\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u00121!\u00138u\u0011\u0019i\u0003\u0001)A\u0005M\u0005Ia.^7O_\u0012,7\u000f\t\u0005\b_\u0001\u0011\r\u0011\"\u0001&\u0003!qW/\u001c)beR\u001c\bBB\u0019\u0001A\u0003%a%A\u0005ok6\u0004\u0016M\u001d;tA!91\u0007\u0001b\u0001\n\u0003!\u0014!\u0002;pa&\u001cW#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001\u00027b]\u001eT\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=o\t11\u000b\u001e:j]\u001eDaA\u0010\u0001!\u0002\u0013)\u0014A\u0002;pa&\u001c\u0007\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bf\nA!\u001e;jY&\u0011q\t\u0012\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB%\u0001A\u0003%!)\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!)1\n\u0001C\u0001\u0019\u0006yq-\u001a8fe\u0006$XmQ8oM&<7\u000fF\u0001N!\rqe+\u0017\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013BA+)\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002VQA\u0011!,X\u0007\u00027*\u0011A\fB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005y[&aC&bM.\f7i\u001c8gS\u001eDq\u0001\u0019\u0001C\u0002\u0013\u0005Q%A\u0005o\u001b\u0016\u001c8/Y4fg\"1!\r\u0001Q\u0001\n\u0019\n!B\\'fgN\fw-Z:!\u0011\u0015!\u0007\u0001\"\u0011f\u0003!!X-\u0019:E_^tG#\u00014\u0011\u0005\u001d:\u0017B\u00015)\u0005\u0011)f.\u001b;)\u0005\rT\u0007CA6n\u001b\u0005a'BA\u0006\u000f\u0013\tqGNA\u0003BMR,'\u000fC\u0003q\u0001\u0011\u0005Q-A\buKN$X*\u001a;sS\u000e\u001cH*Z1lQ\u0011y'/^<\u0011\u0005\u001d\u001a\u0018B\u0001;)\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0002m\u0006AE\u000b[5tAQ,7\u000f\u001e\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002JG\u000fI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/Z\u0011\u0002q\u0006A\u0001GL\u00191]Ar\u0003\u0007\u000b\u0002puB\u00111n_\u0005\u0003y2\u0014A\u0001V3ti\")a\u0010\u0001C\u0001K\u0006)C/Z:u\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe\u00063G/\u001a:EK2,G/\u001b8h)>\u0004\u0018n\u0019\u0015\u0003{jDa!a\u0001\u0001\t\u0003)\u0017\u0001\u000e;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:V]J,w-[:uKJ,G-\u00114uKJ$U\r\\3uS:<Gk\u001c9jG\"\u001a\u0011\u0011\u0001>\t\r\u0005%\u0001\u0001\"\u0001f\u0003M!Xm\u001d;DYV\u001cH/\u001a:JI6+GO]5dQ\r\t9A\u001f\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003U\u0019'/Z1uK\u0006sGm\u00155vi\u0012|wO\\*uKB$rAZA\n\u0003G\t9\u0003\u0003\u0005\u0002\u0016\u00055\u0001\u0019AA\f\u0003\u00159'o\\;q!\u0011\tI\"a\b\u000f\u0007\u001d\nY\"C\u0002\u0002\u001e!\na\u0001\u0015:fI\u00164\u0017b\u0001\u001f\u0002\")\u0019\u0011Q\u0004\u0015\t\u0011\u0005\u0015\u0012Q\u0002a\u0001\u0003/\t!bY8ogVlWM]%e\u0011!\tI#!\u0004A\u0002\u0005]\u0011A\u00039s_\u0012,8-\u001a:JI\"*\u0011Q\u0002:vo\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012aF2iK\u000e\\Gk\u001c9jG6+GO]5dg\u0016C\u0018n\u001d;t)\u0011\t\u0019$!\u000f\u0011\u0007\u001d\n)$C\u0002\u00028!\u0012qAQ8pY\u0016\fg\u000eC\u00044\u0003[\u0001\r!a\u0006")
public class MetricsTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final Properties overridingProps;
    private final int nMessages;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    @TraitSetter
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    @TraitSetter
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetricsTest metricsTest = this;
        synchronized (metricsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$3 = this.numNodes();
        String x$4 = this.zkConnect();
        boolean x$5 = true;
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$3, x$4, x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testMetricsLeak() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.createAndShutdownStep("group0", "consumer0", "producer0");
        Assert.assertNotNull((Object)DelayedFetchMetrics$.MODULE$);
        int countOfStaticMetrics = Metrics.defaultRegistry().allMetrics().keySet().size();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, countOfStaticMetrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final int countOfStaticMetrics$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.createAndShutdownStep(new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToInteger((int)(i % 3))).toString(), new StringBuilder().append((Object)"consumer").append((Object)BoxesRunTime.boxToInteger((int)(i % 2))).toString(), new StringBuilder().append((Object)"producer").append((Object)BoxesRunTime.boxToInteger((int)(i % 2))).toString());
                Assert.assertEquals((long)this.countOfStaticMetrics$1, (long)Metrics.defaultRegistry().allMetrics().keySet().size());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.countOfStaticMetrics$1 = countOfStaticMetrics$1;
            }
        });
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertFalse((String)"Topic metrics exists after deleteTopic", (boolean)this.checkTopicMetricsExists(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.createAndShutdownStep("group0", "consumer0", "producer0");
        Assert.assertNotNull((Object)BrokerTopicStats$.MODULE$.getBrokerTopicStats(topic));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertFalse((String)"Topic metrics exists after deleteTopic", (boolean)this.checkTopicMetricsExists(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$2) {
                return x$2.getMBeanName().equals("kafka.server:type=KafkaServer,name=ClusterId");
            }
        }), (long)1L);
    }

    public void createAndShutdownStep(String group, String consumerId, String producerId) {
        TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), TestUtils$.MODULE$.sendMessages$default$4(), TestUtils$.MODULE$.sendMessages$default$5());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages());
        zkConsumerConnector1.shutdown();
    }

    private boolean checkTopicMetricsExists(String topic) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                Regex topicMetricRegex = new Regex(new StringBuilder().append((Object)".*(").append((Object)topic).append((Object)")$").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                Set metricGroups = Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).entrySet();
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(metricGroups).asScala()).foreach((Function1)new Serializable(this, topicMetricRegex, object){
                    public static final long serialVersionUID = 0L;
                    private final Regex topicMetricRegex$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Map.Entry<String, SortedMap<MetricName, Metric>> metricGroup) {
                        if (this.topicMetricRegex$1.pattern().matcher(metricGroup.getKey()).matches()) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                    }
                    {
                        this.topicMetricRegex$1 = topicMetricRegex$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public MetricsTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.numNodes = 2;
        this.numParts = 2;
        this.topic = "topic1";
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

