/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u000f\t!B)\u001a7bs\u0016$w\n]3sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\t\u0011\u0002];sO\u0006$xN]=\u0016\u0003Y\u00012AE\f\u001a\u0013\tA\"AA\rEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B+(oZ1u_JL\bC\u0001\u000e\u001c\u001b\u0005\u0001a\u0001\u0002\u000f\u0001\u0001u\u0011A#T8dW\u0012+G.Y=fI>\u0003XM]1uS>t7CA\u000e\u001f!\t\u0011r$\u0003\u0002!\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\nEm\u0011\t\u0011)A\u0005G\u0019\nq\u0001Z3mCfl5\u000f\u0005\u0002\nI%\u0011QE\u0003\u0002\u0005\u0019>tw-\u0003\u0002#?!)qb\u0007C\u0001QQ\u0011\u0011$\u000b\u0005\u0006E\u001d\u0002\ra\t\u0005\bWm\u0001\r\u0011\"\u0001-\u0003-\u0019w.\u001c9mKR\f'\r\\3\u0016\u00035\u0002\"!\u0003\u0018\n\u0005=R!a\u0002\"p_2,\u0017M\u001c\u0005\bcm\u0001\r\u0011\"\u00013\u0003=\u0019w.\u001c9mKR\f'\r\\3`I\u0015\fHCA\u001a7!\tIA'\u0003\u00026\u0015\t!QK\\5u\u0011\u001d9\u0004'!AA\u00025\n1\u0001\u001f\u00132\u0011\u0019I4\u0004)Q\u0005[\u0005a1m\\7qY\u0016$\u0018M\u00197fA!)1h\u0007C\u0001y\u0005y\u0011m^1ji\u0016C\b/\u001b:bi&|g\u000eF\u00014\u0011\u0015q4\u0004\"\u0011@\u0003-!(/_\"p[BdW\r^3\u0015\u00035BQ!Q\u000e\u0005Bq\nAb\u001c8FqBL'/\u0019;j_:DQaQ\u000e\u0005Bq\n!b\u001c8D_6\u0004H.\u001a;f\u0011\u001d)\u0005\u00011A\u0005\u0002\u0019\u000bQ\u0002];sO\u0006$xN]=`I\u0015\fHCA\u001aH\u0011\u001d9D)!AA\u0002YAa!\u0013\u0001!B\u00131\u0012A\u00039ve\u001e\fGo\u001c:zA!)1\n\u0001C\u0001y\u0005)1/\u001a;Va\"\u0012!*\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bQA[;oSRT\u0011AU\u0001\u0004_J<\u0017B\u0001+P\u0005\u0019\u0011UMZ8sK\")a\u000b\u0001C\u0001y\u0005AA/Z1s\t><h\u000e\u000b\u0002V1B\u0011a*W\u0005\u00035>\u0013Q!\u00114uKJDQ\u0001\u0018\u0001\u0005\u0002q\nq\u0003^3tiJ+\u0017/^3tiN\u000bG/[:gC\u000e$\u0018n\u001c8)\u0005ms\u0006C\u0001(`\u0013\t\u0001wJ\u0001\u0003UKN$\b\"\u00022\u0001\t\u0003a\u0014!\u0005;fgR\u0014V-];fgR,\u0005\u0010]5ss\"\u0012\u0011M\u0018\u0005\u0006K\u0002!\t\u0001P\u0001\u0011i\u0016\u001cHOU3rk\u0016\u001cH\u000fU;sO\u0016D#\u0001\u001a0")
public class DelayedOperationTest {
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3()));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(100000L);
        MockDelayedOperation r2 = new MockDelayedOperation(100000L);
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start2 = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(expiration);
        MockDelayedOperation r2 = new MockDelayedOperation(200000L);
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start2;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time for expiration ", " should at least ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(100000L);
        MockDelayedOperation r2 = new MockDelayedOperation(100000L);
        MockDelayedOperation r3 = new MockDelayedOperation(100000L);
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().delayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), (long)2L, (long)this.purgatory().delayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), (long)1L, (long)this.purgatory().delayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 4 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)1L, (long)this.purgatory().watched());
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private boolean completable;

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            ((Object)((Object)this)).wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public synchronized void onComplete() {
            ((Object)((Object)this)).notify();
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return DelayedOperationTest.this;
        }

        public MockDelayedOperation(long delayMs) {
            if (DelayedOperationTest.this == null) {
                throw null;
            }
            super(delayMs);
            this.completable = false;
        }
    }
}

