/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\t\u0011B*Z1eKJ,E.Z2uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003%\u0011'o\\6fe&#\u0017'F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0015\t\u0014xn[3s\u0013\u0012\f\u0004\u0005C\u0004*\u0001\t\u0007I\u0011A\u0010\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0014\u0004BB\u0016\u0001A\u0003%\u0001%\u0001\u0006ce>\\WM]%ee\u0001Bq!\f\u0001A\u0002\u0013\u0005a&A\u0004tKJ4XM]:\u0016\u0003=\u00022\u0001\r\u001d<\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u00025\r\u00051AH]8pizJ\u0011aI\u0005\u0003o\t\nq\u0001]1dW\u0006<W-\u0003\u0002:u\t\u00191+Z9\u000b\u0005]\u0012\u0003C\u0001\u000f=\u0013\ti$AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB \u0001\u0001\u0004%\t\u0001Q\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002B\tB\u0011\u0011EQ\u0005\u0003\u0007\n\u0012A!\u00168ji\"9QIPA\u0001\u0002\u0004y\u0013a\u0001=%c!1q\t\u0001Q!\n=\n\u0001b]3sm\u0016\u00148\u000f\t\u0005\b\u0013\u0002\u0001\r\u0011\"\u0001K\u0003q\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012,\u0012a\u0013\t\u0003C1K!!\u0014\u0012\u0003\u000f\t{w\u000e\\3b]\"9q\n\u0001a\u0001\n\u0003\u0001\u0016\u0001I:uC2,7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eR3uK\u000e$X\rZ0%KF$\"!Q)\t\u000f\u0015s\u0015\u0011!a\u0001\u0017\"11\u000b\u0001Q!\n-\u000bQd\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eDG)\u001a;fGR,G\r\t\u0005\u0006+\u0002!\tEV\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0003\"\u0012A\u000b\u0017\t\u00033nk\u0011A\u0017\u0006\u0003\u00179I!\u0001\u0018.\u0003\r\t+gm\u001c:f\u0011\u0015q\u0006\u0001\"\u0011W\u0003!!X-\u0019:E_^t\u0007FA/a!\tI\u0016-\u0003\u0002c5\n)\u0011I\u001a;fe\")A\r\u0001C\u0001K\u0006QB/Z:u\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u0003:$W\t]8dQV\t\u0011\t\u000b\u0002dOB\u0011\u0011\f[\u0005\u0003Sj\u0013A\u0001V3ti\")1\u000e\u0001C\u0001-\u0006QC/Z:u\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\bn\u0015;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007F\u00016h\u0011\u0015q\u0007\u0001\"\u0003p\u0003q\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u000e\u000bG\u000e\u001c2bG.$\"!\u00119\t\u000bEl\u0007\u0019\u0001:\u0002\u0011I,7\u000f]8og\u0016\u0004\"a]>\u000e\u0003QT!!\u001e<\u0002\u0011I,\u0017/^3tiNT!a\u001e=\u0002\r\r|W.\\8o\u0015\t)\u0011P\u0003\u0002{\u001d\u00051\u0011\r]1dQ\u0016L!\u0001 ;\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007")
public class LeaderElectionTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers;
    private boolean staleControllerEpochDetected;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LeaderElectionTest leaderElectionTest = this;
        synchronized (leaderElectionTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        Properties configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps1), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps2), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testLeaderElectionAndEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        Option leader1 = (Option)TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0));
        int leaderEpoch1 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leaderEpoch1){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch1$1)).toString();
            }
            {
                this.leaderEpoch1$1 = leaderEpoch1$1;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final Option leader1$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader1$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader1$1 = leader1$1;
            }
        });
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader1.isDefined());
        Assert.assertTrue((String)"Leader could be broker 0 or broker 1", (BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First epoch value should be 0", (long)0L, (long)leaderEpoch1);
        ((KafkaServer)this.servers().last()).shutdown();
        ZkUtils x$3 = this.zkUtils();
        String x$4 = topic;
        int x$5 = partitionId;
        None$ x$6 = BoxesRunTime.unboxToInt((Object)leader1.get()) == 0 ? None$.MODULE$ : leader1;
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$4, x$5, x$7, (Option<Object>)x$6, x$8);
        int leaderEpoch2 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final Option leader1$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader1$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader1$1 = leader1$1;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leaderEpoch2){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch2$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch2$1)).toString();
            }
            {
                this.leaderEpoch2$1 = leaderEpoch2$1;
            }
        });
        Assert.assertEquals((String)"Leader must move to broker 0", (long)0L, (long)BoxesRunTime.unboxToInt((Object)leader2.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        if (BoxesRunTime.unboxToInt((Object)leader1.get()) == BoxesRunTime.unboxToInt((Object)leader2.get())) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Second epoch value should be ").append((Object)BoxesRunTime.boxToInteger((int)leaderEpoch1)).append((Object)BoxesRunTime.boxToInteger((int)1)).toString(), (long)(leaderEpoch1 + 1), (long)leaderEpoch2);
        } else {
            Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 1))})), (long)(leaderEpoch1 + 1), (long)leaderEpoch2);
        }
        ((KafkaServer)this.servers().last()).startup();
        ((KafkaServer)this.servers().head()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        ZkUtils x$9 = this.zkUtils();
        String x$10 = topic;
        int x$11 = partitionId;
        Option<Object> x$12 = BoxesRunTime.unboxToInt((Object)leader2.get()) == 1 ? None$.MODULE$ : leader2;
        long x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$14 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        Option<Object> leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$9, x$10, x$11, x$13, x$12, x$14);
        int leaderEpoch3 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leaderEpoch3){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch3$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch3$1)).toString();
            }
            {
                this.leaderEpoch3$1 = leaderEpoch3$1;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leader3){
            public static final long serialVersionUID = 0L;
            private final Option leader3$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader3$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader3$1 = leader3$1;
            }
        });
        Assert.assertEquals((String)"Leader must return to 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader3.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        if (BoxesRunTime.unboxToInt((Object)leader2.get()) == BoxesRunTime.unboxToInt((Object)leader3.get())) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Second epoch value should be ").append((Object)BoxesRunTime.boxToInteger((int)leaderEpoch2)).toString(), (long)leaderEpoch2, (long)leaderEpoch3);
        } else {
            Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 1))})), (long)(leaderEpoch2 + 1), (long)leaderEpoch3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        Option leader1 = (Option)TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0));
        int leaderEpoch1 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leaderEpoch1){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch1$2;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch1$2)).toString();
            }
            {
                this.leaderEpoch1$2 = leaderEpoch1$2;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final Option leader1$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader1$2.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader1$2 = leader1$2;
            }
        });
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader1.isDefined());
        Assert.assertTrue((String)"Leader could be broker 0 or broker 1", (BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First epoch value should be 0", (long)0L, (long)leaderEpoch1);
        int controllerId = 2;
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)this.servers().map((Function1)new Serializable(this, securityProtocol, listenerName){
            public static final long serialVersionUID = 0L;
            private final SecurityProtocol securityProtocol$1;
            private final ListenerName listenerName$1;

            public final Broker apply(KafkaServer s) {
                return new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort(s, TestUtils$.MODULE$.boundPort$default$2()), this.listenerName$1, this.securityProtocol$1);
            }
            {
                this.securityProtocol$1 = securityProtocol$1;
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq nodes = (Seq)brokers.map((Function1)new Serializable(this, listenerName){
            public static final long serialVersionUID = 0L;
            private final ListenerName listenerName$1;

            public final Node apply(Broker x$2) {
                return x$2.getNode(this.listenerName$1);
            }
            {
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext(this.zkUtils());
        controllerContext.liveBrokers_$eq((Set)brokers.toSet());
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, ControllerChannelManager$.MODULE$.$lessinit$greater$default$5());
        controllerChannelManager.startup();
        try {
            int staleControllerEpoch = 0;
            scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partitionId)), (Object)new PartitionState(2, this.brokerId2(), LeaderAndIsr$.MODULE$.initialLeaderEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(int x$1) {
                    return x$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava(), LeaderAndIsr$.MODULE$.initialZKVersion(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(int x$1) {
                    return x$1;
                }
            }, Set$.MODULE$.canBuildFrom())).asJava()))}));
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(controllerId, staleControllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            controllerChannelManager.sendRequest(this.brokerId2(), ApiKeys.LEADER_AND_ISR, (AbstractRequest.Builder)requestBuilder, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LeaderElectionTest $outer;

                public final void apply(AbstractResponse response) {
                    this.$outer.kafka$server$LeaderElectionTest$$staleControllerEpochCallback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LeaderElectionTest $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.staleControllerEpochDetected();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, "Controller epoch should be stale", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Stale controller epoch not detected by the broker", (boolean)this.staleControllerEpochDetected());
        }
        catch (Throwable throwable) {
            void var12_12;
            void var13_13;
            var13_13.shutdown();
            var12_12.close();
            throw throwable;
        }
        controllerChannelManager.shutdown();
        metrics.close();
    }

    public void kafka$server$LeaderElectionTest$$staleControllerEpochCallback(AbstractResponse response) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)response;
        Errors errors = Errors.forCode((short)leaderAndIsrResponse.errorCode());
        boolean bl = Errors.STALE_CONTROLLER_EPOCH.equals(errors);
        this.staleControllerEpochDetected_$eq(bl);
    }

    public LeaderElectionTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.staleControllerEpochDetected = false;
    }
}

