/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.admin.AdminUtils$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotasTest$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.parallel.ParIterableLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001\u001d\u0011QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u0001>l\u0013\t9BC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\tA\u0002]3sG\u0016tG/\u0012:s_J$2\u0001\t\u0014,!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011auN\\4\t\u000b\u001dj\u0002\u0019\u0001\u0015\u0002\u000fA,'oY3oiB\u0011\u0011%K\u0005\u0003U\t\u00121!\u00138u\u0011\u0015aS\u00041\u0001!\u0003\u00151\u0018\r\\;f\u0011\u001dq\u0003A1A\u0005\u0002=\n\u0001\"\\:hcA\u00024JQ\u000b\u0002aA\u0019\u0011%M\u001a\n\u0005I\u0012#!B!se\u0006L\bCA\u00115\u0013\t)$E\u0001\u0003CsR,\u0007BB\u001c\u0001A\u0003%\u0001'A\u0005ng\u001e\f\u0004\u0007M&CA!9\u0011\b\u0001a\u0001\n\u0003Q\u0014a\u00022s_.,'o]\u000b\u0002wA\u0019A\bR$\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002DE\u00059\u0001/Y2lC\u001e,\u0017BA#G\u0005\r\u0019V-\u001d\u0006\u0003\u0007\n\u0002\"\u0001\b%\n\u0005%\u0013!aC&bM.\f7+\u001a:wKJDqa\u0013\u0001A\u0002\u0013\u0005A*A\u0006ce>\\WM]:`I\u0015\fHCA'Q!\t\tc*\u0003\u0002PE\t!QK\\5u\u0011\u001d\t&*!AA\u0002m\n1\u0001\u001f\u00132\u0011\u0019\u0019\u0006\u0001)Q\u0005w\u0005A!M]8lKJ\u001c\b\u0005C\u0004V\u0001\t\u0007I\u0011\u0001,\u0002\u000bQ|\u0007/[2\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t1\fgn\u001a\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016L\u0001\u0004TiJLgn\u001a\u0005\u0007A\u0002\u0001\u000b\u0011B,\u0002\rQ|\u0007/[2!\u0011\u001d\u0011\u0007\u00011A\u0005\u0002\r\f\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002IB!Q\r\u001c\u00191\u001b\u00051'B\u00012h\u0015\tA\u0017.A\u0004dY&,g\u000e^:\u000b\u0005\u0015Q'BA6\u000f\u0003\u0019\t\u0007/Y2iK&\u0011QN\u001a\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\u000f=\u0004\u0001\u0019!C\u0001a\u0006a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u0011Q*\u001d\u0005\b#:\f\t\u00111\u0001e\u0011\u0019\u0019\b\u0001)Q\u0005I\u0006I\u0001O]8ek\u000e,'\u000f\t\u0005\u0006k\u0002!\tE^\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u001b\"\u0012A\u000f\u001f\t\u0003snl\u0011A\u001f\u0006\u0003\u00179I!\u0001 >\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0011w\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019\u00110a\u0001\n\u0007\u0005\u0015!PA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\tA^\u0001,g\"|W\u000f\u001c3C_>$8\u000f\u001e:baR;xN\u0011:pW\u0016\u00148oV5uQ2+\u0017\rZ3s)\"\u0014x\u000e\u001e;mK\"\"\u0011qAA\u0007!\rI\u0018qB\u0005\u0004\u0003#Q(\u0001\u0002+fgRDa!!\u0006\u0001\t\u00031\u0018!L:i_VdGMQ8piN$(/\u00199Uo>\u0014%o\\6feN<\u0016\u000e\u001e5G_2dwn^3s)\"\u0014x\u000e\u001e;mK\"\"\u00111CA\u0007\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\tag\u001d5pk2$W*\u0019;dQF+x\u000e^1SKBd\u0017nY1uS:<G\u000b\u001b:pk\u001eD\u0017I\\!ts6lW\r\u001e:jGR{\u0007o\u001c7pOf$2!TA\u0010\u0011!\t\t#!\u0007A\u0002\u0005\r\u0012A\u00047fC\u0012,'\u000f\u00165s_R$H.\u001a\t\u0004C\u0005\u0015\u0012bAA\u0014E\t9!i\\8mK\u0006t\u0007bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u0003iB$B!a\f\u0002<A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026%\faaY8n[>t\u0017\u0002BA\u001d\u0003g\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002>\u0005%\u0002\u0019\u0001\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007BBA!\u0001\u0011\u0005a/A\rtQ>,H\u000e\u001a+ie>$H\u000f\\3PY\u0012\u001cVmZ7f]R\u001c\b\u0006BA \u0003\u001bAq!a\u0012\u0001\t\u0003\tI%A\u0004bI\u0012$\u0015\r^1\u0015\r\u0005\r\u00121JA(\u0011\u001d\ti%!\u0012A\u0002!\n\u0001\"\\:h\u0007>,h\u000e\u001e\u0005\b\u0003#\n)\u00051\u00011\u0003\ri7o\u001a\u0005\b\u0003+\u0002A\u0011BA,\u0003U9\u0018-\u001b;G_J|eMZ:fiN$v.T1uG\"$\u0002\"a\t\u0002Z\u0005u\u0013\u0011\r\u0005\b\u00037\n\u0019\u00061\u0001)\u0003\u0019ygMZ:fi\"9\u0011qLA*\u0001\u0004A\u0013a\u00039beRLG/[8o\u0013\u0012Dq!a\u0019\u0002T\u0001\u0007\u0001&\u0001\u0005ce>\\WM]%e\u0011\u001d\t9\u0007\u0001C\u0005\u0003S\n\u0011B\u0019:pW\u0016\u0014hi\u001c:\u0015\u0007\u001d\u000bY\u0007C\u0004\u0002n\u0005\u0015\u0004\u0019\u0001\u0015\u0002\u0005%$\u0007bBA9\u0001\u0011\u0005\u00111O\u0001\u000eGJ,\u0017\r^3Ce>\\WM]:\u0015\u00075\u000b)\b\u0003\u0005\u0002x\u0005=\u0004\u0019AA=\u0003%\u0011'o\\6fe&#7\u000fE\u0002=\t\"Bq!! \u0001\t\u0013\ty(\u0001\u0004bmJ\u000bG/\u001a\u000b\u0007\u0003\u0003\u000b9)!%\u0011\u0007\u0005\n\u0019)C\u0002\u0002\u0006\n\u0012a\u0001R8vE2,\u0007\u0002CAE\u0003w\u0002\r!a#\u0002\u001fI,\u0007\u000f\\5dCRLwN\u001c+za\u0016\u00042\u0001HAG\u0013\r\tyI\u0001\u0002\n#V|G/\u0019+za\u0016Dq!OA>\u0001\u0004\tI\bC\u0004\u0002\u0016\u0002!I!a&\u0002\u00195,\u0017m];sK\u0012\u0014\u0016\r^3\u0015\r\u0005\u0005\u0015\u0011TAO\u0011\u001d\tY*a%A\u0002\u001d\u000baA\u0019:pW\u0016\u0014\b\u0002CAP\u0003'\u0003\r!a#\u0002\u000fI,\u0007\u000fV=qK\u0002")
public class ReplicationQuotasTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final byte[] msg100KB;
    private Seq<KafkaServer> brokers;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationQuotasTest replicationQuotasTest = this;
        synchronized (replicationQuotasTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public long percentError(int percent, long value) {
        return Math.round(value * (long)percent / 100L);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ((ParIterableLike)this.brokers().par()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        this.producer().close();
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;

            public final KafkaServer apply(int id) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 107})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        LongRef throttle = LongRef.create((long)(msgCount * msg.length / expectedDuration));
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)new Serializable(this, throttle){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final LongRef throttle$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                AdminUtils$.MODULE$.changeBrokerConfig(this.$outer.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)this.throttle$1.elem)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)this.throttle$1.elem)).toString())})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.throttle$1 = throttle$1;
            }
        });
        if (leaderThrottle) {
            AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$9 = 5;
        int x$10 = 1;
        long x$11 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$12 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$14 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$15 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$16 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$17 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$18 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$19 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$20 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$8, x$10, x$11, x$12, x$9, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgCount).foreach$mVc$sp((Function1)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            public final byte[] msg$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$2 $outer;

                    public final Future<RecordMetadata> apply(int partition) {
                        return this.$outer.kafka$server$ReplicationQuotasTest$$anonfun$$$outer().producer().send(new ProducerRecord(this.$outer.kafka$server$ReplicationQuotasTest$$anonfun$$$outer().topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)this.$outer.msg$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.msg$1 = msg$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1)new Serializable(this, msgCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final int msgCount$1;

            public final boolean apply(int id) {
                return this.apply$mcZI$sp(id);
            }

            public boolean apply$mcZI$sp(int id) {
                return this.$outer.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(this.msgCount$1, id, 100 + id);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.msgCount$1 = msgCount$1;
            }
        });
        this.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(msgCount, 6, 100);
        this.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(msgCount, 7, 101);
        long start2 = System.currentTimeMillis();
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)new Serializable(this, throttle){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final LongRef throttle$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                Assert.assertEquals((long)this.throttle$1.elem, (long)this.$outer.kafka$server$ReplicationQuotasTest$$brokerFor(brokerId).quotaManagers().follower().upperBound());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.throttle$1 = throttle$1;
            }
        });
        if (!leaderThrottle) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotasTest $outer;

                public final void apply(int partition) {
                    this.apply$mcVI$sp(partition);
                }

                public void apply$mcVI$sp(int partition) {
                    Assert.assertTrue((boolean)this.$outer.kafka$server$ReplicationQuotasTest$$brokerFor(106).quotaManagers().follower().isThrottled(this.$outer.tp(partition)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotasTest $outer;

                public final void apply(int partition) {
                    this.apply$mcVI$sp(partition);
                }

                public void apply$mcVI$sp(int partition) {
                    Assert.assertTrue((boolean)this.$outer.kafka$server$ReplicationQuotasTest$$brokerFor(107).quotaManagers().follower().isThrottled(this.$outer.tp(partition)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 7).foreach((Function1)new Serializable(this, msgCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final int msgCount$1;

            public final boolean apply(int id) {
                return this.apply$mcZI$sp(id);
            }

            public boolean apply$mcZI$sp(int id) {
                return this.$outer.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(this.msgCount$1, id, 100 + id);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.msgCount$1 = msgCount$1;
            }
        });
        long unthrottledTook = System.currentTimeMillis() - start2;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1)new Serializable(this, msgCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final int msgCount$1;

            public final boolean apply(int id) {
                return this.apply$mcZI$sp(id);
            }

            public boolean apply$mcZI$sp(int id) {
                return this.$outer.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(this.msgCount$1, id, 106);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.msgCount$1 = msgCount$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach((Function1)new Serializable(this, msgCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final int msgCount$1;

            public final boolean apply(int id) {
                return this.apply$mcZI$sp(id);
            }

            public boolean apply$mcZI$sp(int id) {
                return this.$outer.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(this.msgCount$1, id, 107);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.msgCount$1 = msgCount$1;
            }
        });
        long throttledTook = System.currentTimeMillis() - start2;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)unthrottledTook), BoxesRunTime.boxToDouble((double)throttledLowerBound)})), ((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttledTook), BoxesRunTime.boxToDouble((double)throttledLowerBound)})), ((double)throttledTook > throttledLowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttledTook), BoxesRunTime.boxToInteger((int)throttledUpperBound)})), (throttledTook < (long)throttledUpperBound ? 1 : 0) != 0);
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        double rate = leaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rate), BoxesRunTime.boxToDouble((double)rateUpperBound)})), (rate < rateUpperBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rate), BoxesRunTime.boxToDouble((double)rateLowerBound)})), (rate > rateLowerBound ? 1 : 0) != 0);
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    @Test
    public void shouldThrottleOldSegments() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        config.put("log.segment.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        this.brokers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2())}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)throttle)).toString()));
        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100"));
        this.addData(msgCount, msg);
        long start2 = System.currentTimeMillis();
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        this.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start2;
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throttled replication of ", "ms should be > ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttledTook), BoxesRunTime.boxToDouble((double)((double)(expectedDuration * 1000) * 0.9))})), ((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throttled replication of ", "ms should be < ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttledTook), BoxesRunTime.boxToInteger((int)(expectedDuration * 1500))})), ((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0);
    }

    public boolean addData(int msgCount, byte[] msg) {
        String x$21 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$22 = 5;
        int x$23 = 0;
        long x$24 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$25 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$26 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$27 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$28 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$29 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$30 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$31 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$32 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$33 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$21, x$23, x$24, x$25, x$22, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33));
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final byte[] msg$2;

            public final Future<RecordMetadata> apply(int x$3) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), (Object)this.msg$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.msg$2 = msg$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$4) {
                return x$4.get();
            }
        });
        return this.kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(msgCount, 0, 100);
    }

    public boolean kafka$server$ReplicationQuotasTest$$waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        return TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, offset, partitionId, brokerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final int offset$1;
            private final int partitionId$1;
            private final int brokerId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)this.offset$1), (Object)this.$outer.kafka$server$ReplicationQuotasTest$$brokerFor(this.brokerId$1).getLogManager().getLog(new TopicPartition(this.$outer.topic(), this.partitionId$1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Log x$5) {
                        return x$5.logEndOffset();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.partitionId$1 = partitionId$1;
                this.brokerId$1 = brokerId$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offsets did not match for partition ", " on broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)brokerId)})), 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public KafkaServer kafka$server$ReplicationQuotasTest$$brokerFor(int id) {
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final int id$1;

            public final boolean apply(KafkaServer x$6) {
                return x$6.config().brokerId() == this.id$1;
            }
            {
                this.id$1 = id$1;
            }
        })).head();
    }

    public void createBrokers(Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;

            public final void apply(int id) {
                this.apply$mcVI$sp(id);
            }

            public void apply$mcVI$sp(int id) {
                this.$outer.brokers_$eq((Seq<KafkaServer>)((Seq)this.$outer.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private double avRate(QuotaType replicationType, Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;

            public final KafkaServer apply(int id) {
                return this.$outer.kafka$server$ReplicationQuotasTest$$brokerFor(id);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, replicationType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotasTest $outer;
            private final QuotaType replicationType$1;

            public final double apply(KafkaServer x$7) {
                return this.$outer.kafka$server$ReplicationQuotasTest$$measuredRate(x$7, this.replicationType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicationType$1 = replicationType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    public double kafka$server$ReplicationQuotasTest$$measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return ((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).value();
    }

    public ReplicationQuotasTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.msg100KB = new byte[100000];
        this.brokers = null;
        this.topic = "topic1";
        this.producer = null;
    }
}

