/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001 !\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#AA\u0005QCJ$\u0018\u000e^5p]\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005i&lW\r\u0005\u0002)c5\t\u0011F\u0003\u0002\u0012U)\u00111\u0006L\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i#B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001eL!AM\u0015\u0003\tQKW.\u001a\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005I\u0012N\\5uS\u0006d\u0007*[4i/\u0006$XM]7be.4\u0016\r\\;f!\tIa'\u0003\u00028\u0015\t!Aj\u001c8h\u0011!I\u0004A!b\u0001\n\u0003Q\u0014a\u00017pOV\t1\bE\u0002\nyyJ!!\u0010\u0006\u0003\r=\u0003H/[8o!\ty\u0014)D\u0001A\u0015\tID!\u0003\u0002C\u0001\n\u0019Aj\\4\t\u0011\u0011\u0003!\u0011!Q\u0001\nm\nA\u0001\\8hA!)a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"b\u0001S%K\u00172k\u0005C\u0001\u0011\u0001\u0011\u0015)R\t1\u0001\u0018\u0011\u0015iR\t1\u0001 \u0011\u001d1S\t%AA\u0002\u001dBq\u0001N#\u0011\u0002\u0003\u0007Q\u0007C\u0004:\u000bB\u0005\t\u0019A\u001e\t\r=\u0003\u0001\u0015)\u0003Q\u0003UA\u0017n\u001a5XCR,'/\\1sW6+G/\u00193bi\u0006\u0004\"!\u0015+\u000e\u0003IS!a\u0015\u0003\u0002\rM,'O^3s\u0013\t)&KA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006D#AT,\u0011\u0005%A\u0016BA-\u000b\u0005!1x\u000e\\1uS2,\u0007BB.\u0001A\u0003&\u0001+\u0001\u000bm_\u001e,e\u000eZ(gMN,G/T3uC\u0012\fG/\u0019\u0015\u00035^CaA\u0018\u0001!B\u0013)\u0014a\u00077bgR4U\r^2i\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000f\u000b\u0002^/\"1\u0011\r\u0001Q!\nU\nq\u0002\\1ti\u001a+Go\u00195US6,Wj\u001d\u0015\u0003A^Ca\u0001\u001a\u0001!B\u0013)\u0014aE0mCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\bFA2X\u0011\u001d9\u0007A1A\u0005\u0002!\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001j!\tQ7.D\u0001+\u0013\ta'F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r9\u0004\u0001\u0015!\u0003j\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003\"\u00029\u0001\t\u0003\t\u0018aB5t\u0019>\u001c\u0017\r\\\u000b\u0002eB\u0011\u0011b]\u0005\u0003i*\u0011qAQ8pY\u0016\fg\u000eC\u0003w\u0001\u0011\u0005q/\u0001\nmCN$8)Y;hQR,\u0006\u000fV5nK6\u001bX#A\u001b\t\u000be\u0004A\u0011\u0001>\u0002'U\u0004H-\u0019;f\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\u0015\u0005mt\bCA\u0005}\u0013\ti(B\u0001\u0003V]&$\bBB@y\u0001\u0004\t\t!A\u0007m_\u001e\u0014V-\u00193SKN,H\u000e\u001e\t\u0004#\u0006\r\u0011bAA\u0003%\niAj\\4SK\u0006$'+Z:vYRDq!!\u0003\u0001\t\u0003\tY!A\u000bsKN,G\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3\u0015\u000fm\fi!!\u0005\u0002\u0016!9\u0011qBA\u0004\u0001\u0004)\u0014!F2ve2+\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003'\t9\u00011\u00016\u0003%\u0019WO\u001d+j[\u0016l5\u000f\u0003\u0004w\u0003\u000f\u0001\r!\u000e\u0005\b\u00033\u0001A\u0011BA\u000e\u0003AawnZ#oI>3gm]3u?\u0012*\u0017\u000fF\u0002|\u0003;Aq!a\b\u0002\u0018\u0001\u0007\u0001+A\boK^dunZ#oI>3gm]3u\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tA\u0002\\8h\u000b:$wJ\u001a4tKR,\u0012\u0001\u0015\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003EA\u0017n\u001a5XCR,'/\\1sW~#S-\u001d\u000b\u0004w\u00065\u0002bBA\u0018\u0003O\u0001\r\u0001U\u0001\u0011]\u0016<\b*[4i/\u0006$XM]7be.Dq!a\r\u0001\t\u0003\t)#A\u0007iS\u001eDw+\u0019;fe6\f'o\u001b\u0005\b\u0003o\u0001A\u0011AA\u001d\u0003y\u0019wN\u001c<feRDu\u000bV8M_\u000e\fGn\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rF\u0001|\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\ta!Z9vC2\u001cHc\u0001:\u0002B!A\u00111IA\u001e\u0001\u0004\t)%\u0001\u0003uQ\u0006$\bcA\u0005\u0002H%\u0019\u0011\u0011\n\u0006\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002N\u0001!\t%a\u0014\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u0006\u0005\b\u0003'\u0002A\u0011IA+\u0003!!xn\u0015;sS:<GCAA,!\u0011\tI&a\u0018\u000f\u0007%\tY&C\u0002\u0002^)\ta\u0001\u0015:fI\u00164\u0017\u0002BA1\u0003G\u0012aa\u0015;sS:<'bAA/\u0015\u001dI\u0011q\r\u0002\u0002\u0002#\u0005\u0011\u0011N\u0001\b%\u0016\u0004H.[2b!\r\u0001\u00131\u000e\u0004\t\u0003\t\t\t\u0011#\u0001\u0002nM\u0019\u00111\u000e\u0005\t\u000f\u0019\u000bY\u0007\"\u0001\u0002rQ\u0011\u0011\u0011\u000e\u0005\u000b\u0003k\nY'%A\u0005\u0002\u0005]\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002z)\u001aq%a\u001f,\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\"\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\u000b\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a$\u0002lE\u0005I\u0011AAI\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0013\u0016\u0004k\u0005m\u0004BCAL\u0003W\n\n\u0011\"\u0001\u0002\u001a\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a'+\u0007m\nY\b")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$logEndOffsetMetadata;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private final TopicPartition topicPartition;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log end offset on partition ", "'s local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log end offset for replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), this.$outer.kafka$cluster$Replica$$logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.kafka$cluster$Replica$$logEndOffsetMetadata;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            this.highWatermarkMetadata = newHighWatermark;
            this.trace((Function0<String>)new Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting high watermark for replica ", " partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = ((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not construct complete high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"ReplicaId: ").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.partition().topic()).toString());
        replicaString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partition().partitionId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; isLocal: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLocal())).toString());
        replicaString.append(new StringBuilder().append((Object)"; lastCaughtUpTimeMs: ").append((Object)BoxesRunTime.boxToLong((long)this.lastCaughtUpTimeMs())).toString());
        Object object = this.isLocal() ? replicaString.append(new StringBuilder().append((Object)"; Highwatermark: ").append((Object)this.highWatermark()).toString()) : BoxedUnit.UNIT;
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.partition = partition;
        this.log = log;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.kafka$cluster$Replica$$logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.topicPartition = partition.topicPartition();
    }
}

