/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NumericUtils;

public class DoubleRangeFacetCounts
extends RangeFacetCounts {
    public DoubleRangeFacetCounts(String field, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, (ValueSource)new DoubleFieldSource(field), hits, ranges);
    }

    public DoubleRangeFacetCounts(String field, ValueSource valueSource, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Query)null, ranges);
    }

    public DoubleRangeFacetCounts(String field, ValueSource valueSource, FacetsCollector hits, Query fastMatchQuery, DoubleRange ... ranges) throws IOException {
        super(field, ranges, fastMatchQuery);
        this.count(valueSource, hits.getMatchingDocs());
    }

    private void count(ValueSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        DoubleRange[] ranges = (DoubleRange[])this.ranges;
        LongRange[] longRanges = new LongRange[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            DoubleRange range = ranges[i];
            longRanges[i] = new LongRange(range.label, NumericUtils.doubleToSortableLong((double)range.minIncl), true, NumericUtils.doubleToSortableLong((double)range.maxIncl), true);
        }
        LongRangeCounter counter = new LongRangeCounter(longRanges);
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            Scorer fastMatchDocs;
            FunctionValues fv = valueSource.getValues(Collections.emptyMap(), hits.context);
            this.totCount += hits.totalHits;
            if (this.fastMatchQuery != null) {
                IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)hits.context);
                IndexSearcher searcher = new IndexSearcher(topLevelContext);
                searcher.setQueryCache(null);
                Weight fastMatchWeight = searcher.createNormalizedWeight(this.fastMatchQuery, false);
                fastMatchDocs = fastMatchWeight.scorer(hits.context);
                if (fastMatchDocs == null) {
                    continue;
                }
            } else {
                fastMatchDocs = null;
            }
            DocIdSetIterator docs = hits.bits.iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fastMatchDocs != null) {
                    int fastMatchDoc = fastMatchDocs.docID();
                    if (fastMatchDoc < doc) {
                        fastMatchDoc = fastMatchDocs.advance(doc);
                    }
                    if (doc != fastMatchDoc) {
                        doc = docs.advance(fastMatchDoc);
                        continue;
                    }
                }
                if (fv.exists(doc)) {
                    counter.add(NumericUtils.doubleToSortableLong((double)fv.doubleVal(doc)));
                } else {
                    ++missingCount;
                }
                doc = docs.nextDoc();
            }
        }
        this.totCount -= (missingCount += counter.fillCounts(this.counts));
    }
}

