/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.util.List;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.util.BytesRef;

public class TermQueryPrefixTreeStrategy
extends PrefixTreeStrategy {
    public TermQueryPrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (op != SpatialOperation.Intersects) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        List<Node> cells = this.grid.getNodes(shape, detailLevel, false);
        BytesRef[] terms = new BytesRef[cells.size()];
        int i = 0;
        for (Node cell : cells) {
            terms[i++] = new BytesRef((CharSequence)cell.getTokenString());
        }
        return new TermsFilter(this.getFieldName(), terms);
    }
}

